// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    date_time::DateTime,
    extension_object::ExtensionObject,
};

#[derive(Debug, Clone, PartialEq)]
pub struct NotificationMessage {
    pub sequence_number: u32,
    pub publish_time: DateTime,
    pub notification_data: Option<Vec<ExtensionObject>>,
}

impl MessageInfo for NotificationMessage {
    fn object_id(&self) -> ObjectId {
        ObjectId::NotificationMessage_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<NotificationMessage> for NotificationMessage {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.sequence_number.byte_len();
        size += self.publish_time.byte_len();
        size += byte_len_array(&self.notification_data);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.sequence_number.encode(stream)?;
        size += self.publish_time.encode(stream)?;
        size += write_array(stream, &self.notification_data)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let sequence_number = u32::decode(stream, decoding_options)?;
        let publish_time = DateTime::decode(stream, decoding_options)?;
        let notification_data: Option<Vec<ExtensionObject>> = read_array(stream, decoding_options)?;
        Ok(NotificationMessage {
            sequence_number,
            publish_time,
            notification_data,
        })
    }
}
