// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    node_id::NodeId,
};

#[derive(Debug, Clone, PartialEq)]
pub struct ModelChangeStructureDataType {
    pub affected: NodeId,
    pub affected_type: NodeId,
    pub verb: u8,
}

impl MessageInfo for ModelChangeStructureDataType {
    fn object_id(&self) -> ObjectId {
        ObjectId::ModelChangeStructureDataType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<ModelChangeStructureDataType> for ModelChangeStructureDataType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.affected.byte_len();
        size += self.affected_type.byte_len();
        size += self.verb.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.affected.encode(stream)?;
        size += self.affected_type.encode(stream)?;
        size += self.verb.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let affected = NodeId::decode(stream, decoding_options)?;
        let affected_type = NodeId::decode(stream, decoding_options)?;
        let verb = u8::decode(stream, decoding_options)?;
        Ok(ModelChangeStructureDataType {
            affected,
            affected_type,
            verb,
        })
    }
}
