// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    string::UAString,
    byte_string::ByteString,
};

#[derive(Debug, Clone, PartialEq)]
pub struct IssuedIdentityToken {
    pub policy_id: UAString,
    pub token_data: ByteString,
    pub encryption_algorithm: UAString,
}

impl BinaryEncoder<IssuedIdentityToken> for IssuedIdentityToken {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.policy_id.byte_len();
        size += self.token_data.byte_len();
        size += self.encryption_algorithm.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.policy_id.encode(stream)?;
        size += self.token_data.encode(stream)?;
        size += self.encryption_algorithm.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let policy_id = UAString::decode(stream, decoding_options)?;
        let token_data = ByteString::decode(stream, decoding_options)?;
        let encryption_algorithm = UAString::decode(stream, decoding_options)?;
        Ok(IssuedIdentityToken {
            policy_id,
            token_data,
            encryption_algorithm,
        })
    }
}
