// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    node_id::NodeId,
    string::UAString,
    qualified_name::QualifiedName,
    byte_string::ByteString,
};

#[derive(Debug, Clone, PartialEq)]
pub struct HistoryReadValueId {
    pub node_id: NodeId,
    pub index_range: UAString,
    pub data_encoding: QualifiedName,
    pub continuation_point: ByteString,
}

impl MessageInfo for HistoryReadValueId {
    fn object_id(&self) -> ObjectId {
        ObjectId::HistoryReadValueId_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<HistoryReadValueId> for HistoryReadValueId {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.node_id.byte_len();
        size += self.index_range.byte_len();
        size += self.data_encoding.byte_len();
        size += self.continuation_point.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.node_id.encode(stream)?;
        size += self.index_range.encode(stream)?;
        size += self.data_encoding.encode(stream)?;
        size += self.continuation_point.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let node_id = NodeId::decode(stream, decoding_options)?;
        let index_range = UAString::decode(stream, decoding_options)?;
        let data_encoding = QualifiedName::decode(stream, decoding_options)?;
        let continuation_point = ByteString::decode(stream, decoding_options)?;
        Ok(HistoryReadValueId {
            node_id,
            index_range,
            data_encoding,
            continuation_point,
        })
    }
}
