// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    data_value::DataValue,
};

#[derive(Debug, Clone, PartialEq)]
pub struct HistoryData {
    pub data_values: Option<Vec<DataValue>>,
}

impl MessageInfo for HistoryData {
    fn object_id(&self) -> ObjectId {
        ObjectId::HistoryData_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<HistoryData> for HistoryData {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += byte_len_array(&self.data_values);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += write_array(stream, &self.data_values)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let data_values: Option<Vec<DataValue>> = read_array(stream, decoding_options)?;
        Ok(HistoryData {
            data_values,
        })
    }
}
