// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    response_header::ResponseHeader,
    service_types::EndpointDescription,
};

#[derive(Debug, Clone, PartialEq)]
pub struct GetEndpointsResponse {
    pub response_header: ResponseHeader,
    pub endpoints: Option<Vec<EndpointDescription>>,
}

impl MessageInfo for GetEndpointsResponse {
    fn object_id(&self) -> ObjectId {
        ObjectId::GetEndpointsResponse_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<GetEndpointsResponse> for GetEndpointsResponse {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.response_header.byte_len();
        size += byte_len_array(&self.endpoints);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.response_header.encode(stream)?;
        size += write_array(stream, &self.endpoints)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let response_header = ResponseHeader::decode(stream, decoding_options)?;
        let endpoints: Option<Vec<EndpointDescription>> = read_array(stream, decoding_options)?;
        Ok(GetEndpointsResponse {
            response_header,
            endpoints,
        })
    }
}
