// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    guid::Guid,
    string::UAString,
    node_id::NodeId,
    service_types::enums::OverrideValueHandling,
    variant::Variant,
};

#[derive(Debug, Clone, PartialEq)]
pub struct FieldTargetDataType {
    pub data_set_field_id: Guid,
    pub receiver_index_range: UAString,
    pub target_node_id: NodeId,
    pub attribute_id: u32,
    pub write_index_range: UAString,
    pub override_value_handling: OverrideValueHandling,
    pub override_value: Variant,
}

impl MessageInfo for FieldTargetDataType {
    fn object_id(&self) -> ObjectId {
        ObjectId::FieldTargetDataType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<FieldTargetDataType> for FieldTargetDataType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.data_set_field_id.byte_len();
        size += self.receiver_index_range.byte_len();
        size += self.target_node_id.byte_len();
        size += self.attribute_id.byte_len();
        size += self.write_index_range.byte_len();
        size += self.override_value_handling.byte_len();
        size += self.override_value.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.data_set_field_id.encode(stream)?;
        size += self.receiver_index_range.encode(stream)?;
        size += self.target_node_id.encode(stream)?;
        size += self.attribute_id.encode(stream)?;
        size += self.write_index_range.encode(stream)?;
        size += self.override_value_handling.encode(stream)?;
        size += self.override_value.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let data_set_field_id = Guid::decode(stream, decoding_options)?;
        let receiver_index_range = UAString::decode(stream, decoding_options)?;
        let target_node_id = NodeId::decode(stream, decoding_options)?;
        let attribute_id = u32::decode(stream, decoding_options)?;
        let write_index_range = UAString::decode(stream, decoding_options)?;
        let override_value_handling = OverrideValueHandling::decode(stream, decoding_options)?;
        let override_value = Variant::decode(stream, decoding_options)?;
        Ok(FieldTargetDataType {
            data_set_field_id,
            receiver_index_range,
            target_node_id,
            attribute_id,
            write_index_range,
            override_value_handling,
            override_value,
        })
    }
}
