// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    variant::Variant,
};

#[derive(Debug, Clone, PartialEq, Serialize)]
pub struct EventFieldList {
    pub client_handle: u32,
    pub event_fields: Option<Vec<Variant>>,
}

impl MessageInfo for EventFieldList {
    fn object_id(&self) -> ObjectId {
        ObjectId::EventFieldList_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<EventFieldList> for EventFieldList {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.client_handle.byte_len();
        size += byte_len_array(&self.event_fields);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.client_handle.encode(stream)?;
        size += write_array(stream, &self.event_fields)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let client_handle = u32::decode(stream, decoding_options)?;
        let event_fields: Option<Vec<Variant>> = read_array(stream, decoding_options)?;
        Ok(EventFieldList {
            client_handle,
            event_fields,
        })
    }
}
