// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    byte_string::ByteString,
};

#[derive(Debug, Clone, PartialEq)]
pub struct EphemeralKeyType {
    pub public_key: ByteString,
    pub signature: ByteString,
}

impl MessageInfo for EphemeralKeyType {
    fn object_id(&self) -> ObjectId {
        ObjectId::EphemeralKeyType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<EphemeralKeyType> for EphemeralKeyType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.public_key.byte_len();
        size += self.signature.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.public_key.encode(stream)?;
        size += self.signature.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let public_key = ByteString::decode(stream, decoding_options)?;
        let signature = ByteString::decode(stream, decoding_options)?;
        Ok(EphemeralKeyType {
            public_key,
            signature,
        })
    }
}
