// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    localized_text::LocalizedText,
    string::UAString,
};

#[derive(Debug, Clone, PartialEq)]
pub struct EnumField {
    pub value: i64,
    pub display_name: LocalizedText,
    pub description: LocalizedText,
    pub name: UAString,
}

impl BinaryEncoder<EnumField> for EnumField {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.value.byte_len();
        size += self.display_name.byte_len();
        size += self.description.byte_len();
        size += self.name.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.value.encode(stream)?;
        size += self.display_name.encode(stream)?;
        size += self.description.encode(stream)?;
        size += self.name.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let value = i64::decode(stream, decoding_options)?;
        let display_name = LocalizedText::decode(stream, decoding_options)?;
        let description = LocalizedText::decode(stream, decoding_options)?;
        let name = UAString::decode(stream, decoding_options)?;
        Ok(EnumField {
            value,
            display_name,
            description,
            name,
        })
    }
}
