// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    string::UAString,
};

#[derive(Debug, Clone, PartialEq)]
pub struct EndpointUrlListDataType {
    pub endpoint_url_list: Option<Vec<UAString>>,
}

impl MessageInfo for EndpointUrlListDataType {
    fn object_id(&self) -> ObjectId {
        ObjectId::EndpointUrlListDataType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<EndpointUrlListDataType> for EndpointUrlListDataType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += byte_len_array(&self.endpoint_url_list);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += write_array(stream, &self.endpoint_url_list)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let endpoint_url_list: Option<Vec<UAString>> = read_array(stream, decoding_options)?;
        Ok(EndpointUrlListDataType {
            endpoint_url_list,
        })
    }
}
