// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
};

#[derive(Debug, Clone, PartialEq)]
pub struct DatagramWriterGroupTransportDataType {
    pub message_repeat_count: u8,
    pub message_repeat_delay: f64,
}

impl BinaryEncoder<DatagramWriterGroupTransportDataType> for DatagramWriterGroupTransportDataType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.message_repeat_count.byte_len();
        size += self.message_repeat_delay.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.message_repeat_count.encode(stream)?;
        size += self.message_repeat_delay.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let message_repeat_count = u8::decode(stream, decoding_options)?;
        let message_repeat_delay = f64::decode(stream, decoding_options)?;
        Ok(DatagramWriterGroupTransportDataType {
            message_repeat_count,
            message_repeat_delay,
        })
    }
}
