// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    string::UAString,
    service_types::enums::DataSetFieldContentMask,
    extension_object::ExtensionObject,
    service_types::KeyValuePair,
};

#[derive(Debug, Clone, PartialEq)]
pub struct DataSetWriterDataType {
    pub name: UAString,
    pub enabled: bool,
    pub data_set_writer_id: u16,
    pub data_set_field_content_mask: DataSetFieldContentMask,
    pub key_frame_count: u32,
    pub data_set_name: UAString,
    pub data_set_writer_properties: Option<Vec<KeyValuePair>>,
    pub transport_settings: ExtensionObject,
    pub message_settings: ExtensionObject,
}

impl MessageInfo for DataSetWriterDataType {
    fn object_id(&self) -> ObjectId {
        ObjectId::DataSetWriterDataType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<DataSetWriterDataType> for DataSetWriterDataType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.name.byte_len();
        size += self.enabled.byte_len();
        size += self.data_set_writer_id.byte_len();
        size += self.data_set_field_content_mask.byte_len();
        size += self.key_frame_count.byte_len();
        size += self.data_set_name.byte_len();
        size += byte_len_array(&self.data_set_writer_properties);
        size += self.transport_settings.byte_len();
        size += self.message_settings.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.name.encode(stream)?;
        size += self.enabled.encode(stream)?;
        size += self.data_set_writer_id.encode(stream)?;
        size += self.data_set_field_content_mask.encode(stream)?;
        size += self.key_frame_count.encode(stream)?;
        size += self.data_set_name.encode(stream)?;
        size += write_array(stream, &self.data_set_writer_properties)?;
        size += self.transport_settings.encode(stream)?;
        size += self.message_settings.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let name = UAString::decode(stream, decoding_options)?;
        let enabled = bool::decode(stream, decoding_options)?;
        let data_set_writer_id = u16::decode(stream, decoding_options)?;
        let data_set_field_content_mask = DataSetFieldContentMask::decode(stream, decoding_options)?;
        let key_frame_count = u32::decode(stream, decoding_options)?;
        let data_set_name = UAString::decode(stream, decoding_options)?;
        let data_set_writer_properties: Option<Vec<KeyValuePair>> = read_array(stream, decoding_options)?;
        let transport_settings = ExtensionObject::decode(stream, decoding_options)?;
        let message_settings = ExtensionObject::decode(stream, decoding_options)?;
        Ok(DataSetWriterDataType {
            name,
            enabled,
            data_set_writer_id,
            data_set_field_content_mask,
            key_frame_count,
            data_set_name,
            data_set_writer_properties,
            transport_settings,
            message_settings,
        })
    }
}
