// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
};

#[derive(Debug, Clone, PartialEq)]
pub struct ComplexNumberType {
    pub real: f32,
    pub imaginary: f32,
}

impl MessageInfo for ComplexNumberType {
    fn object_id(&self) -> ObjectId {
        ObjectId::ComplexNumberType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<ComplexNumberType> for ComplexNumberType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.real.byte_len();
        size += self.imaginary.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.real.encode(stream)?;
        size += self.imaginary.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let real = f32::decode(stream, decoding_options)?;
        let imaginary = f32::decode(stream, decoding_options)?;
        Ok(ComplexNumberType {
            real,
            imaginary,
        })
    }
}
