// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    request_header::RequestHeader,
};

#[derive(Debug, Clone, PartialEq)]
pub struct CancelRequest {
    pub request_header: RequestHeader,
    pub request_handle: u32,
}

impl MessageInfo for CancelRequest {
    fn object_id(&self) -> ObjectId {
        ObjectId::CancelRequest_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<CancelRequest> for CancelRequest {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.request_header.byte_len();
        size += self.request_handle.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.request_header.encode(stream)?;
        size += self.request_handle.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let request_header = RequestHeader::decode(stream, decoding_options)?;
        let request_handle = u32::decode(stream, decoding_options)?;
        Ok(CancelRequest {
            request_header,
            request_handle,
        })
    }
}
