// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    status_codes::StatusCode,
    diagnostic_info::DiagnosticInfo,
    variant::Variant,
};

#[derive(Debug, Clone, PartialEq)]
pub struct CallMethodResult {
    pub status_code: StatusCode,
    pub input_argument_results: Option<Vec<StatusCode>>,
    pub input_argument_diagnostic_infos: Option<Vec<DiagnosticInfo>>,
    pub output_arguments: Option<Vec<Variant>>,
}

impl MessageInfo for CallMethodResult {
    fn object_id(&self) -> ObjectId {
        ObjectId::CallMethodResult_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<CallMethodResult> for CallMethodResult {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.status_code.byte_len();
        size += byte_len_array(&self.input_argument_results);
        size += byte_len_array(&self.input_argument_diagnostic_infos);
        size += byte_len_array(&self.output_arguments);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.status_code.encode(stream)?;
        size += write_array(stream, &self.input_argument_results)?;
        size += write_array(stream, &self.input_argument_diagnostic_infos)?;
        size += write_array(stream, &self.output_arguments)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let status_code = StatusCode::decode(stream, decoding_options)?;
        let input_argument_results: Option<Vec<StatusCode>> = read_array(stream, decoding_options)?;
        let input_argument_diagnostic_infos: Option<Vec<DiagnosticInfo>> = read_array(stream, decoding_options)?;
        let output_arguments: Option<Vec<Variant>> = read_array(stream, decoding_options)?;
        Ok(CallMethodResult {
            status_code,
            input_argument_results,
            input_argument_diagnostic_infos,
            output_arguments,
        })
    }
}
