// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    node_id::NodeId,
    variant::Variant,
};

#[derive(Debug, Clone, PartialEq)]
pub struct CallMethodRequest {
    pub object_id: NodeId,
    pub method_id: NodeId,
    pub input_arguments: Option<Vec<Variant>>,
}

impl MessageInfo for CallMethodRequest {
    fn object_id(&self) -> ObjectId {
        ObjectId::CallMethodRequest_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<CallMethodRequest> for CallMethodRequest {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.object_id.byte_len();
        size += self.method_id.byte_len();
        size += byte_len_array(&self.input_arguments);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.object_id.encode(stream)?;
        size += self.method_id.encode(stream)?;
        size += write_array(stream, &self.input_arguments)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let object_id = NodeId::decode(stream, decoding_options)?;
        let method_id = NodeId::decode(stream, decoding_options)?;
        let input_arguments: Option<Vec<Variant>> = read_array(stream, decoding_options)?;
        Ok(CallMethodRequest {
            object_id,
            method_id,
            input_arguments,
        })
    }
}
