// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    status_codes::StatusCode,
    byte_string::ByteString,
    service_types::ReferenceDescription,
};

#[derive(Debug, Clone, PartialEq)]
pub struct BrowseResult {
    pub status_code: StatusCode,
    pub continuation_point: ByteString,
    pub references: Option<Vec<ReferenceDescription>>,
}

impl MessageInfo for BrowseResult {
    fn object_id(&self) -> ObjectId {
        ObjectId::BrowseResult_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<BrowseResult> for BrowseResult {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.status_code.byte_len();
        size += self.continuation_point.byte_len();
        size += byte_len_array(&self.references);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.status_code.encode(stream)?;
        size += self.continuation_point.encode(stream)?;
        size += write_array(stream, &self.references)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let status_code = StatusCode::decode(stream, decoding_options)?;
        let continuation_point = ByteString::decode(stream, decoding_options)?;
        let references: Option<Vec<ReferenceDescription>> = read_array(stream, decoding_options)?;
        Ok(BrowseResult {
            status_code,
            continuation_point,
            references,
        })
    }
}
