// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
};

#[derive(Debug, Clone, PartialEq)]
pub struct AggregateConfiguration {
    pub use_server_capabilities_defaults: bool,
    pub treat_uncertain_as_bad: bool,
    pub percent_data_bad: u8,
    pub percent_data_good: u8,
    pub use_sloped_extrapolation: bool,
}

impl MessageInfo for AggregateConfiguration {
    fn object_id(&self) -> ObjectId {
        ObjectId::AggregateConfiguration_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<AggregateConfiguration> for AggregateConfiguration {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.use_server_capabilities_defaults.byte_len();
        size += self.treat_uncertain_as_bad.byte_len();
        size += self.percent_data_bad.byte_len();
        size += self.percent_data_good.byte_len();
        size += self.use_sloped_extrapolation.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.use_server_capabilities_defaults.encode(stream)?;
        size += self.treat_uncertain_as_bad.encode(stream)?;
        size += self.percent_data_bad.encode(stream)?;
        size += self.percent_data_good.encode(stream)?;
        size += self.use_sloped_extrapolation.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let use_server_capabilities_defaults = bool::decode(stream, decoding_options)?;
        let treat_uncertain_as_bad = bool::decode(stream, decoding_options)?;
        let percent_data_bad = u8::decode(stream, decoding_options)?;
        let percent_data_good = u8::decode(stream, decoding_options)?;
        let use_sloped_extrapolation = bool::decode(stream, decoding_options)?;
        Ok(AggregateConfiguration {
            use_server_capabilities_defaults,
            treat_uncertain_as_bad,
            percent_data_bad,
            percent_data_good,
            use_sloped_extrapolation,
        })
    }
}
