// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    service_types::KeyValuePair,
};

#[derive(Debug, Clone, PartialEq)]
pub struct AdditionalParametersType {
    pub parameters: Option<Vec<KeyValuePair>>,
}

impl MessageInfo for AdditionalParametersType {
    fn object_id(&self) -> ObjectId {
        ObjectId::AdditionalParametersType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<AdditionalParametersType> for AdditionalParametersType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += byte_len_array(&self.parameters);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += write_array(stream, &self.parameters)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let parameters: Option<Vec<KeyValuePair>> = read_array(stream, decoding_options)?;
        Ok(AdditionalParametersType {
            parameters,
        })
    }
}
