extern {
    pub fn Kraken_Decompress(src: *const u8, src_len: usize, dst: *mut u8, dst_len: usize) -> i32;
}

#[cfg(test)]
mod tests {
    use crate::Kraken_Decompress;

    #[test]
    fn unsafe_decompress() {
        let src = include_bytes!("../mermaid-fortnite.dump");
        let mut dst = vec![0u8; 405273];
        let result =
            unsafe { Kraken_Decompress(src.as_ptr(), src.len(), dst.as_mut_ptr(), dst.len()) };
        assert_eq!(result as usize, dst.len());
    }
}
