/*! by [ontology](https://onto.logy.at/)

A dsl (domain specific language) for writing html. This is NOT an html template (there are lots of those).
This library is not complete and most possibly will never be -html is huge.

## usage
```
use onhtml::*  ;
fn myhomepage1() ->String  {
	let mut x = Title("a page")  ;
	x += &meta() .name("description") .Content("bla bla")  ;
	x += &Style("some inline css")  ;
	x = Head(&x)  ;
	let mut y = a("nst") .href("nst.com") .Download()  ;
	y += &P("nst")  ;
	x += &Body(&y)  ;
	x += &script("") .type_("module") .Src("/res/main.js")  ;
	x = html(&x) .Lang("en")  ;
	doctype(&x)}
fn myhomepage2() ->String  {
	let mut x = Title("a page")  ;
	x += &meta() .name("description") .Content("bla bla")  ;
	x += &link() .rel("stylesheet") .Href("/mycss.css")  ;
	x = Head(&x)  ;
	let mut y = a("nst") .href("nst.com") .data("a","1") .Download()  ;
	y += &P("nst")  ;
	x += &Body(&y)  ;
	x += &script("") .type_("script") .Src("/res/main.js")  ;
	x = html(&x) .Lang("en")  ;
	doctype(&x)}
```

Notice that -and this is against rust conventions- some functions are capitalized. Every function has 2 variants. You can view the capitalized function as the non capitalized function call, followed by a hypothetical .finish() method to close the builder. i.e.
```
let x = a("some link") .href("https://somelink.com") .finish()
```
instead of having the above, we have:
```
let x = a("some link") .Href("https://somelink.com")
```
This was decided for purely ergonomic reasons.

Since everything is a String, if the library misses something, you can always add it manually:
```
let mut x = Div("some content")
x += "<span>some content</span>"
```

**note:** function names that collide with rust's reserved keywords (type, loop etc) are suffixed with an underscore. i.e. type_
 */  
use duplicate::duplicate  ;
struct Attribute  {
	name: String, 
	value: String, }
impl Attribute  {
	fn new(name:String , value:String)->Self  {
		return Attribute  {
			name , 
			value, }}}
struct Orphan  {
	name:  String, 
	attributes: Vec<Attribute>, }
impl Orphan  {
	fn new(name:String)->Self  {
		return Orphan  {
			name , 
			attributes:  vec![] , }}
	fn att(&mut self ,name:String ,value:String) -> &mut Self  {
		self.attributes.push(Attribute::new(name ,value))  ;
		return self  ;}
	pub fn print(&mut self) -> String  {
		let mut x = format!("\n<{}" , self.name)  ;
		for att in &self.attributes  {
			if att.value == ""  {
				x += &format!(" {}" , &att.name)  ;}
			else  {
				x += &format!(" {}='{}'" ,&att.name , &att.value)  ;}}
		x += ">"  ;
		return x  ;}}
//a tag that is not allowed to close (i.e. <meta> ,<link>)  ;
#[allow(non_camel_case_types)]#[duplicate(T; [T_LINK];[T_META];)]pub struct T(Orphan); 
#[duplicate(f name T ; [link]["link"][T_LINK];[meta]["meta"][T_META];)]pub fn f() ->T  {
	let t = Orphan::new(name.to_string())  ;
	return T(t)  ;}
impl T_LINK  {
	pub fn rel(&mut self ,val:&str) -> &mut Self  {
		self.0.att("rel".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn href(&mut self ,val:&str) -> &mut Self  {
		self.0.att("href".to_string() ,val.to_string())  ;
		return self  ;}}
impl T_META  {
	pub fn charset(&mut self ,val:&str) -> &mut Self  {
		self.0.att("charset".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn name(&mut self ,val:&str) -> &mut Self  {
		self.0.att("name".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn content(&mut self ,val:&str) -> &mut Self  {
		self.0.att("content".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn property(&mut self ,val:&str) -> &mut Self  {
		self.0.att("property".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn httpequiv(&mut self ,val:&str) -> &mut Self  {
		self.0.att("http-equiv".to_string() ,val.to_string())  ;
		return self  ;}}
struct Tag  {
	name:  String, 
	value:  String, 
	attributes: Vec<Attribute>, }
impl Tag  {
	fn new(name:String ,value:String)->Self  {
		return Tag  {
			name , 
			value, 
			attributes:  vec![] , }}
	fn att(&mut self ,name:String ,value:String) -> &mut Self  {
		self.attributes.push(Attribute::new(name ,value))  ;
		return self  ;}
	pub fn print(&mut self) -> String  {
		let mut x = format!("\n<{}" , self.name)  ;
		for att in &self.attributes  {
			if att.value == ""  {
				x += &format!(" {}" , &att.name)  ;}
			else  {
				x += &format!(" {}='{}'" ,&att.name , &att.value)  ;}}
		x += &format!( ">{}</{}>" , &self.value , &self.name )  ;
		return x  ;}}
#[allow(non_camel_case_types)]#[duplicate(T; [T_BIG]; [T_IFRAME]; [T_FIGURE]; [T_SMALL]; [T_MARQUEE]; [T_Q]; [T_MAIN]; [T_NAV]; [T_FOOTER]; [T_HEADER]; [T_B]; [T_LABEL]; [T_DATALIST]; [T_CODE]; [T_ARTICLE]; [T_ASIDE]; [T_SECTION]; [T_P]; [T_OL]; [T_UL]; [T_LI]; [T_OPTION]; [T_PRE]; [T_CANVAS]; [T_BLOCKQUOTE]; [T_SOURCE]; [T_SPAN]; [T_A]; [T_FORM]; [T_TEMPLATE]; [T_VIDEO]; [T_TEXTAREA]; [T_SELECT]; [T_H1]; [T_H2]; [T_H3]; [T_H4]; [T_H5]; [T_H6]; [T_BUTTON]; [T_DIV]; [T_IMG]; [T_INPUT];[T_HEAD];[T_STYLE];[T_TITLE];[T_SCRIPT];[T_BODY];[T_HTML];)]pub struct T(Tag); 
#[duplicate(f name T ; [big]["big"][T_BIG]; [iframe]["iframe"][T_IFRAME]; [figure]["figure"][T_FIGURE]; [small]["small"][T_SMALL]; [marquee]["marquee"][T_MARQUEE]; [q]["q"][T_Q]; [main_]["main"][T_MAIN]; [nav]["nav"][T_NAV]; [footer]["footer"][T_FOOTER]; [header]["header"][T_HEADER]; [b]["b"][T_B]; [label]["label"][T_LABEL]; [datalist]["datalist"][T_DATALIST]; [code]["code"][T_CODE]; [article]["article"][T_ARTICLE]; [aside]["aside"][T_ASIDE]; [section]["section"][T_SECTION]; [p]["p"][T_P]; [ol]["ol"][T_OL]; [ul]["ul"][T_UL]; [li]["li"][T_LI]; [option]["option"][T_OPTION]; [pre]["pre"][T_PRE]; [canvas]["canvas"][T_CANVAS]; [blockquote]["blockquote"][T_BLOCKQUOTE]; [source]["source"][T_SOURCE]; [span]["span"][T_SPAN]; [a]["a"][T_A]; [form]["form"][T_FORM]; [template]["template"][T_TEMPLATE]; [video]["video"][T_VIDEO]; [textarea]["textarea"][T_TEXTAREA]; [select]["select"][T_SELECT]; [h1]["h1"][T_H1]; [h2]["h2"][T_H2]; [h3]["h3"][T_H3]; [h4]["h4"][T_H4]; [h5]["h5"][T_H5]; [h6]["h6"][T_H6]; [button]["button"][T_BUTTON]; [div]["div"][T_DIV]; [img]["img"][T_IMG]; [input]["input"][T_INPUT];[head]["head"][T_HEAD];[title]["title"][T_TITLE];[style]["style"][T_STYLE];[script]["script"][T_SCRIPT];[body]["body"][T_BODY];[html]["html"][T_HTML];)]pub fn f(val:&str) ->T  {
	let t = Tag::new(name.to_string() ,val.to_string())  ;
	return T(t)  ;}
#[allow(non_snake_case)]#[duplicate(f name; [Big]["big"]; [Iframe]["iframe"]; [Figure]["figure"]; [Small]["small"]; [Marquee]["marquee"]; [Q]["q"]; [Main]["main"]; [Nav]["nav"]; [Footer]["footer"]; [Header]["header"]; [B]["b"]; [Label]["label"]; [Datalist]["datalist"]; [Code]["code"]; [Article]["article"]; [Aside]["aside"]; [Section]["section"]; [P]["p"]; [Ol]["ol"]; [Ul]["ul"]; [Li]["li"]; [Option]["option"]; [Pre]["pre"]; [Canvas]["canvas"]; [Blockquote]["blockquote"]; [Source]["source"]; [Span]["span"]; [A]["a"]; [Form]["form"]; [Template]["template"]; [Video]["video"]; [Textarea]["textarea"]; [Select]["select"]; [H1]["h1"]; [H2]["h2"]; [H3]["h3"]; [H4]["h4"]; [H5]["h5"]; [H6]["h6"]; [Button]["button"]; [Div]["div"]; [Img]["img"]; [Input]["input"];[Head]["head"];[Title]["title"];[Style]["style"];[Script]["script"];[Body]["body"];[Html]["html"];)]pub fn f(val:&str) ->String  {
	return Tag::new(name.to_string() ,val.to_string()) .print()  ;}
#[allow(non_camel_case_types)]#[duplicate(T; [T_BIG]; [T_IFRAME]; [T_FIGURE]; [T_SMALL]; [T_MARQUEE]; [T_Q]; [T_MAIN]; [T_NAV]; [T_FOOTER]; [T_HEADER]; [T_B]; [T_LABEL]; [T_DATALIST]; [T_CODE]; [T_ARTICLE]; [T_ASIDE]; [T_SECTION]; [T_P]; [T_OL]; [T_UL]; [T_LI]; [T_OPTION]; [T_PRE]; [T_CANVAS]; [T_BLOCKQUOTE]; [T_SOURCE]; [T_SPAN]; [T_A]; [T_FORM]; [T_TEMPLATE]; [T_VIDEO]; [T_TEXTAREA]; [T_SELECT]; [T_H1]; [T_H2]; [T_H3]; [T_H4]; [T_H5]; [T_H6]; [T_BUTTON]; [T_DIV]; [T_IMG]; [T_INPUT];[T_HEAD];[T_TITLE];[T_STYLE];[T_SCRIPT];[T_BODY];[T_HTML];)]impl T  {
	pub fn id(&mut self ,val:&str) -> &mut Self  {
		self.0.att("id".to_string() ,val.to_string())  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Id(&mut self ,val:&str) ->String  {
		return self .id(val) .0 .print()  ;}
	pub fn class(&mut self ,val:&str) -> &mut Self  {
		self.0.att("class".to_string() ,val.to_string())  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Class(&mut self ,val:&str) ->String  {
		return self .class(val) .0 .print()  ;}
	pub fn style(&mut self ,val:&str) -> &mut Self  {
		self.0.att("style".to_string() ,val.to_string())  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Style(&mut self ,val:&str) ->String  {
		return self .style(val) .0 .print()  ;}
	pub fn onclick(&mut self ,val:&str) -> &mut Self  {
		self.0.att("onclick".to_string() ,val.to_string())  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Onclick(&mut self ,val:&str) ->String  {
		return self .onclick(val) .0 .print()  ;}
	pub fn onload(&mut self ,val:&str) -> &mut Self  {
		self.0.att("onload".to_string() ,val.to_string())  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Onload(&mut self ,val:&str) ->String  {
		return self .onload(val) .0 .print()  ;}
	pub fn data(&mut self ,key:&str ,val:&str ) -> &mut Self  {
		self.0.att(format!("data-{}",key ).to_string() ,val.to_string())  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Data(&mut self ,key:&str ,val:&str ) ->String  {
		return self .data(key ,val) .0 .print()  ;}
	pub fn contenteditable(&mut self) -> &mut Self  {
		self.0.att("contenteditable".to_string() ,"true".to_string())  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Contenteditable(&mut self) ->String  {
		return self .contenteditable() .0 .print()  ;}
	pub fn draggable(&mut self) -> &mut Self  {
		self.0.att("draggable".to_string() ,"true".to_string())  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Draggable(&mut self) ->String  {
		return self .draggable() .0 .print()  ;}
	pub fn tabindex(&mut self ,n:i32) -> &mut Self  {
		self.0.att("tabindex".to_string() ,format!("{}" ,n))  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Tabindex(&mut self ,n:i32) ->String  {
		return self .tabindex(n) .0 .print()  ;}
	pub fn autocorrect(&mut self ,b:bool) -> &mut Self  {
		if b  {
			self.0.att("autocorrect".to_string() ,"on".to_string())  ;}
		else  {
			self.0.att("autocorrect".to_string() ,"off".to_string())  ;}
		return self  ;}
	#[allow(non_snake_case)] pub fn Autocorrect(&mut self ,b:bool) ->String  {
		return self .autocorrect(b) .0 .print()  ;}
	pub fn autocapitalize(&mut self ,b:bool) -> &mut Self  {
		if b  {
			self.0.att("autocapitalize".to_string() ,"on".to_string())  ;}
		else  {
			self.0.att("autocapitalize".to_string() ,"off".to_string())  ;}
		return self  ;}
	#[allow(non_snake_case)] pub fn Autocapitalize(&mut self ,b:bool) ->String  {
		return self .autocapitalize(b) .0 .print()  ;}
	pub fn spellcheck(&mut self ,b:bool) -> &mut Self  {
		if b  {
			self.0.att("spellcheck".to_string() ,"true".to_string())  ;}
		else  {
			self.0.att("spellcheck".to_string() ,"false".to_string())  ;}
		return self  ;}
	#[allow(non_snake_case)] pub fn Spellcheck(&mut self ,b:bool) ->String  {
		return self .spellcheck(b) .0 .print()  ;}
	pub fn lang(&mut self ,val:&str) -> &mut Self  {
		self.0.att("lang".to_string() ,val.to_string())  ;
		return self  ;}
	#[allow(non_snake_case)] pub fn Lang(&mut self ,val:&str) ->String  {
		return self .lang(val) .0 .print()  ;}}
fn warning(prefix:&str ,xs:Vec<&str> ,attributevalue:&str)  {
	if !xs .contains(&attributevalue)  {
		println!("\n{} must be one of: \n{:?}\n" ,prefix ,xs)  ;}}
impl T_MARQUEE  {
	pub fn behavior(&mut self ,val:&str) -> &mut Self  {
		warning("marquee behavior" ,vec!("scroll","slide","alternate") ,val)  ;
		self.0.att("behavior".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn direction(&mut self ,val:&str) -> &mut Self  {
		warning("marquee direction" ,vec!("left","right","up","down") ,val)  ;
		self.0.att("direction".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn loop_(&mut self ,x:u32) -> &mut Self  {
		self.0.att("loop".to_string() ,format!("{}" ,&x))  ;
		return self  ;}
	pub fn scrollamount(&mut self ,x:u32) -> &mut Self  {
		// bigger = faster  ;
		self.0.att("scrollamount".to_string() ,format!("{}" ,&x))  ;
		return self  ;}
	pub fn hspace(&mut self ,x:&str) -> &mut Self  {
		// bigger = faster  ;
		self.0.att("hspace".to_string() ,x.to_string())  ;
		return self  ;}}
impl T_LI  {
	pub fn value( &mut self ,n:u32) -> &mut Self  {
		self.0.att( "value".to_string() , format!("{}" ,n))  ;
		return self  ;}}
impl T_BLOCKQUOTE  {
	pub fn cite(&mut self ,x:&str) -> &mut Self  {
		self.0.att("cite".to_string() , format!("{}" ,x))  ;
		return self  ;}}
impl T_LABEL  {
	pub fn for_(&mut self ,x:&str) -> &mut Self  {
		self.0.att("for".to_string() , format!("{}" ,x))  ;
		return self  ;}}
impl T_PRE  {
	pub fn oninput(&mut self ,f:&str) -> &mut Self  {
		self.0.att("oninput".to_string() , format!("{}" ,f))  ;
		return self  ;}
	pub fn onchange(&mut self ,f:&str) -> &mut Self  {
		self.0.att("onchange".to_string() , format!("{}" ,f))  ;
		return self  ;}
	pub fn wrap(&mut self) -> &mut Self  {
		self.0.att("wrap".to_string() , "".to_string())  ;
		return self  ;}}
impl T_OL  {
	pub fn reversed(&mut self) -> &mut Self  {
		self.0.att("reversed".to_string() , "".to_string())  ;
		return self  ;}
	pub fn start(&mut self ,n:u32) -> &mut Self  {
		// Specifies the start value of an ordered list  ;
		self.0.att("start".to_string() ,format!("{}" ,n))  ;
		return self  ;}
	pub fn type_(&mut self ,val:&str) -> &mut Self  {
		warning("ol type" ,vec!("1","A","a","I","i") ,val)  ;
		self.0.att("type".to_string() ,val.to_string())  ;
		return self  ;}}
impl T_A  {
	pub fn download(&mut self) -> &mut Self  {
		self.0.att("download".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn href(&mut self ,val:&str) -> &mut Self  {
		self.0.att("href".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn type_(&mut self ,x:&str) -> &mut Self  {
		//@warning  ;
		self.0.att("type".to_string() ,x.to_string())  ;
		return self  ;}
	pub fn hreflang(&mut self ,two_digit_code:&str) -> &mut Self  {
		if two_digit_code .len() != 2  {
			println!("{}" ,"hreflang must be a 2 digit code")  ;}
		self.0.att("hreflang".to_string() ,two_digit_code.to_string())  ;
		return self  ;}
	pub fn ping(&mut self ,urls:Vec<&str>) -> &mut Self  {
		let mut x = "".to_string()  ;
		for url in urls  {
			x += &format!(" {}" ,url)  ;}
		self.0.att("ping".to_string() ,x)  ;
		return self  ;}
	pub fn target(&mut self ,val:&str) -> &mut Self  {
		warning("a target" ,vec!("_blank","_self","_parent","_top") ,val)  ;
		self.0.att("target".to_string() ,val.to_string())  ;
		return self  ;}}
impl T_FORM  {
	pub fn target(&mut self ,val:&str) -> &mut Self  {
		warning("form target" ,vec!("_blank","_self","_parent","_top") ,val)  ;
		self.0.att("target".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn rel(&mut self ,val:&str) -> &mut Self  {
		warning("form rel" ,vec!("external","help","license","next","nofollow","noopener"  ,"noreferrer","opener","prev","search") ,val)  ;
		self.0.att("rel".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn novalidate(&mut self) -> &mut Self  {
		self.0.att("novalidate".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn name(&mut self ,val:&str) -> &mut Self  {
		self.0.att("name".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn onsubmit(&mut self ,val:&str) -> &mut Self  {
		self.0.att("onsubmit".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn action(&mut self ,val:&str) -> &mut Self  {
		self.0.att("action".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn method( &mut self ,val:&str) -> &mut Self  {
		warning("form method" ,vec!("get","post","patch") ,val)  ;
		self.0.att("method".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn enctype( &mut self ,val:&str) -> &mut Self  {
		warning("form enctype" ,vec!("application/x-www-form-urlencoded"  ,"multipart/form-data","text/plain") ,val)  ;
		self.0.att("enctype".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn autocomplete(&mut self ,b:bool) -> &mut Self  {
		if b  {
			self.0.att("autocomplete".to_string() ,"on".to_string())  ;}
		else  {
			self.0.att("autocomplete".to_string() ,"off".to_string())  ;}
		return self  ;}}
impl T_IFRAME  {
	pub fn src(&mut self ,val:&str) -> &mut Self  {
		self.0.att("src".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn loading(&mut self ,val:&str) -> &mut Self  {
		self.0.att("loading".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn allowfullscreen(&mut self) -> &mut Self  {
		self.0.att("allowfullscreen".to_string() , "".to_string())  ;
		return self  ;}}
impl T_IMG  {
	pub fn src(&mut self ,val:&str) -> &mut Self  {
		self.0.att("src".to_string() ,val.to_string())  ;
		return self  ;}}
impl T_SOURCE  {
	pub fn src(&mut self ,val:&str) -> &mut Self  {
		self.0.att("src".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn type_(&mut self ,val:&str) -> &mut Self  {
		self.0.att("type".to_string() ,val.to_string())  ;
		return self  ;}}
impl T_VIDEO  {
	pub fn preload( &mut self ,val:&str) -> &mut Self  {
		warning("video preload" ,vec!("auto","metadata","none") ,val)  ;
		self.0.att("preload".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn autoplay(&mut self) -> &mut Self  {
		self.0.att("autoplay".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn controls(&mut self) -> &mut Self  {
		self.0.att("controls".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn loop_(&mut self) -> &mut Self  {
		self.0.att("loop".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn muted(&mut self) -> &mut Self  {
		self.0.att("muted".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn poster(&mut self ,url:&str) -> &mut Self  {
		self.0.att("poster".to_string() ,url.to_string())  ;
		return self  ;}
	pub fn src(&mut self ,url:&str) -> &mut Self  {
		self.0.att("src".to_string() ,url.to_string())  ;
		return self  ;}
	pub fn width(&mut self ,x:i32) -> &mut Self  {
		self.0.att("width".to_string() ,x.to_string())  ;
		return self  ;}
	pub fn height(&mut self ,x:i32) -> &mut Self  {
		self.0.att("height".to_string() , x.to_string())  ;
		return self  ;}}
impl T_SELECT  {
	pub fn autofocus(&mut self) -> &mut Self  {
		self.0.att("autofocus".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn disabled(&mut self) -> &mut Self  {
		self.0.att("disabled".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn required(&mut self) -> &mut Self  {
		self.0.att("required".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn name(&mut self ,x:&str) -> &mut Self  {
		self.0.att("name".to_string() ,x.to_string())  ;
		return self  ;}
	pub fn size(&mut self ,x:i32) -> &mut Self  {
		self.0.att("size".to_string() ,format!( "{}",x ))  ;
		return self  ;}
	pub fn onchange(&mut self ,f:&str) -> &mut Self  {
		self.0.att("onchange".to_string() ,f.to_string())  ;
		return self  ;}}
impl T_OPTION  {
	pub fn disabled(&mut self) -> &mut Self  {
		self.0.att("disabled".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn selected(&mut self) -> &mut Self  {
		self.0.att("selected".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn hidden(&mut self) -> &mut Self  {
		self.0.att("hidden".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn value(&mut self ,x:&str) -> &mut Self  {
		self.0.att("value".to_string() ,x.to_string())  ;
		return self  ;}}
impl T_BUTTON  {
	pub fn formaction(&mut self ,val:&str) -> &mut Self  {
		self.0.att("formaction".to_string() ,format!("{}" ,val.to_string()))  ;
		return self  ;}
	pub fn autofocus(&mut self) -> &mut Self  {
		self.0.att("autofocus".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn disabled(&mut self) -> &mut Self  {
		self.0.att("disabled".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn name(&mut self ,x:&str) -> &mut Self  {
		self.0.att("name".to_string() ,x.to_string())  ;
		return self  ;}
	pub fn form(&mut self ,x:&str) -> &mut Self  {
		self.0.att("form".to_string() ,x.to_string())  ;
		return self  ;}
	pub fn value(&mut self ,x:&str) -> &mut Self  {
		self.0.att("value".to_string() ,x.to_string())  ;
		return self  ;}
	pub fn type_(&mut self ,val:&str) -> &mut Self  {
		warning("button type" ,vec!("button","submit","reset") ,val)  ;
		self.0.att("type".to_string() ,val.to_string())  ;
		return self  ;}}
impl T_INPUT  {
	pub fn multiple(&mut self) -> &mut Self  {
		self.0.att("multiple".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn minlength(&mut self ,val:i32) -> &mut Self  {
		self.0.att("minlenght".to_string() ,format!("{}" ,val.to_string()))  ;
		return self  ;}
	pub fn value(&mut self ,val:&str) -> &mut Self  {
		self.0.att("value".to_string() ,format!("{}" ,val.to_string()))  ;
		return self  ;}
	pub fn formaction(&mut self ,val:&str) -> &mut Self  {
		self.0.att("formaction".to_string() ,format!("{}" ,val.to_string()))  ;
		return self  ;}
	pub fn title(&mut self ,val:&str) -> &mut Self  {
		self.0.att("title".to_string() ,format!("{}" ,val.to_string()))  ;
		return self  ;}
	pub fn size(&mut self ,val:i32) -> &mut Self  {
		self.0.att("size".to_string() ,format!("{}" ,val.to_string()))  ;
		return self  ;}
	pub fn max(&mut self ,val:&str) -> &mut Self  {
		self.0.att("max".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn list(&mut self ,id:&str) -> &mut Self  {
		// id of the datalist tag (input autocompletion)  ;
		self.0.att("list".to_string() ,id.to_string())  ;
		return self  ;}
	pub fn name(&mut self ,val:&str) -> &mut Self  {
		self.0.att("name".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn placeholder(&mut self ,val:&str) -> &mut Self  {
		self.0.att("placeholder".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn readonly(&mut self) -> &mut Self  {
		self.0.att("readonly".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn min(&mut self ,val:&str) -> &mut Self  {
		self.0.att("min".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn checked(&mut self) -> &mut Self  {
		self.0.att("checked".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn autofocus(&mut self) -> &mut Self  {
		self.0.att("autofocus".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn disabled(&mut self) -> &mut Self  {
		self.0.att("disabled".to_string() ,"".to_string())  ;
		return self  ;}}
impl T_INPUT  {
	pub fn autocomplete(&mut self ,val:bool) -> &mut Self  {
		if val  {
			self.0.att( "autocomplete".to_string() , "on".to_string() )  ;}
		else  {
			self.0.att( "autocomplete".to_string() , "off".to_string() )  ;}
		return self  ;}
	pub fn alt(&mut self ,val:&str) -> &mut Self  {
		let mut b = false  ;
		for a in &self.0.attributes  {
			if a.name == "type" && a.value == "image"  {
				b = true  ;}}
		self.0.att("alt".to_string() ,val.to_string())  ;
		if !b  {
			println!("THE 'alt' ATT IS ONLY VALID FOR ATT: type=image" )  ;}
		return self  ;}
	pub fn accept(&mut self ,val:&str) -> &mut Self  {
		let mut b = false  ;
		for a in &self.0.attributes  {
			if (a.name == "type" && a.value == "text")   ||  (a.name == "type" && a.value == "file")  {
				b = true  ;}}
		self.0.att("accept".to_string() ,val.to_string())  ;
		if !b  {
			println!(   "THE 'accept' ATT IS ONLY VALID FOR ATT: type=text|file" )  ;}
		return self  ;}
	pub fn type_(&mut self , val:&str) -> &mut Self  {
		warning("input type" ,vec!("button","checkbox","color","date","datetimeLocal"  ,"email","file","hidden","image","month","number","password","radio","range"  ,"reset","search","submit","tel","text","time","url","week") ,val)  ;
		self.0.att("type".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn onchange(&mut self ,val:&str) -> &mut Self  {
		self.0.att("onchange".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn oninput(&mut self ,val:&str) -> &mut Self  {
		self.0.att("onchange".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn oninvalid(&mut self ,val:&str) -> &mut Self  {
		self.0.att("oninvalid".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn required(&mut self) -> &mut Self  {
		self.0.att("required".to_string() ,"".to_string())  ;
		return self  ;}}
impl T_TEXTAREA  {
	pub fn autofocus(&mut self) -> &mut Self  {
		self.0.att("autofocus".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn disabled(&mut self) -> &mut Self  {
		self.0.att("disabled".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn readonly(&mut self) -> &mut Self  {
		self.0.att("readonly".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn required(&mut self) -> &mut Self  {
		self.0.att("required".to_string() ,"".to_string())  ;
		return self  ;}
	pub fn cols(&mut self , x:i32) -> &mut Self  {
		self.0.att("cols".to_string() ,format!( "{}",x ).to_string())  ;
		return self  ;}
	pub fn rows(&mut self ,x:i32) -> &mut Self  {
		self.0.att("rows".to_string() ,format!( "{}",x ).to_string())  ;
		return self  ;}
	pub fn maxlength(&mut self ,x:i32) -> &mut Self  {
		self.0.att("maxlength".to_string() ,format!( "{}",x ).to_string())  ;
		return self  ;}
	pub fn name(&mut self ,x:&str) -> &mut Self  {
		self.0.att("name".to_string() ,x.to_string())  ;
		return self  ;}
	pub fn placeholder(&mut self ,x:&str) -> &mut Self  {
		self.0.att("placeholder".to_string() ,x.to_string())  ;
		return self  ;}
	pub fn onchange(&mut self ,f:&str) -> &mut Self  {
		self.0.att("onchange".to_string() ,f.to_string())  ;
		return self  ;}
	pub fn oninput(&mut self ,f:&str) -> &mut Self  {
		self.0.att("oninput".to_string() ,f.to_string())  ;
		return self  ;}}
impl T_SCRIPT  {
	pub fn type_(&mut self ,val:&str) -> &mut Self  {
		warning("script type" ,vec!("script","module") ,val)  ;
		self.0.att("type".to_string() ,val.to_string())  ;
		return self  ;}
	pub fn src(&mut self ,val:&str) -> &mut Self  {
		self.0.att("src".to_string() ,val.to_string())  ;
		return self  ;}}
#[duplicate(f g T;  [wrap][Wrap][T_PRE]; [reversed][Reversed][T_OL]; [download][Download][T_A]; [novalidate][Novalidate][T_FORM];  [allowfullscreen][Allowfullscreen][T_IFRAME]; [autoplay][Autoplay][T_VIDEO]; [controls][Controls][T_VIDEO]; [loop_][Loop][T_VIDEO]; [muted][Muted][T_VIDEO]; [autofocus][Autofocus][T_SELECT]; [disabled][Disabled][T_SELECT]; [required][Required][T_SELECT]; [disabled][Disabled][T_OPTION]; [selected][Selected][T_OPTION]; [hidden][Hidden][T_OPTION]; [autofocus][Autofocus][T_BUTTON]; [disabled][Disabled][T_BUTTON]; [multiple][Multiple][T_INPUT]; [readonly][Readonly][T_INPUT]; [checked][Checked][T_INPUT]; [autofocus][Autofocus][T_INPUT]; [disabled][Disabled][T_INPUT]; [required][Required][T_INPUT]; [autofocus][Autofocus][T_TEXTAREA]; [disabled][Disabled][T_TEXTAREA]; [readonly][Readonly][T_TEXTAREA]; [required][Required][T_TEXTAREA]; )] #[allow(non_snake_case)] impl T{pub fn g(&mut self) ->String  {
		return self .f() .0 .print()  ;}}
#[duplicate(f g T; [behavior][Behavior][T_MARQUEE];[direction][Direction][T_MARQUEE];[hspace][Hspace][T_MARQUEE];[cite][Cite][T_BLOCKQUOTE];[for_][For][T_LABEL];[oninput][Oninput][T_PRE];[onchange][Onchange][T_PRE];[type_][Type][T_OL];[href][Href][T_A];[type_][Type][T_A];[hreflang][Hreflang][T_A];[target][Target][T_FORM]; [target][Target][T_A]; [rel][Rel][T_FORM];[name][Name][T_FORM];[onsubmit][Onsubmit][T_FORM];[action][Action][T_FORM];[method][Method][T_FORM];[enctype][Enctype][T_FORM];[src][Src][T_IFRAME];[loading][Loading][T_IFRAME];[src][Src][T_IMG];[src][Src][T_SOURCE];[type_][Type][T_SOURCE];[preload][Preload][T_VIDEO];[poster][Poster][T_VIDEO];[src][Src][T_VIDEO];[name][Name][T_SELECT];[onchange][Onchange][T_SELECT];[value][Value][T_OPTION];[formaction][Formaction][T_BUTTON];[name][Name][T_BUTTON];[form][Form][T_BUTTON];[value][Value][T_BUTTON];[type_][Type][T_BUTTON];[value][Value][T_INPUT];[formaction][Formaction][T_INPUT];[title][Title][T_INPUT];[max][Max][T_INPUT];[list][List][T_INPUT];[name][Name][T_INPUT];[placeholder][Placeholder][T_INPUT];[min][Min][T_INPUT];[alt][Alt][T_INPUT];[accept][Accept][T_INPUT];[type_][Type][T_INPUT];[onchange][Onchange][T_INPUT];[oninput][Oninput][T_INPUT];[oninvalid][Oninvalid][T_INPUT];[name][Name][T_TEXTAREA];[placeholder][Placeholder][T_TEXTAREA];[onchange][Onchange][T_TEXTAREA];[oninput][Oninput][T_TEXTAREA];[rel][Rel][T_LINK];[href][Href][T_LINK];[charset][Charset][T_META];[name][Name][T_META];[content][Content][T_META];[property][Property][T_META];[httpequiv][Httpequiv][T_META];[type_][Type][T_SCRIPT];[src][Src][T_SCRIPT];)]#[allow(non_snake_case)]impl T{pub fn g(&mut self ,x:&str) ->String  {
		return self .f(x) .0 .print()  ;}}
#[duplicate(f g T; [loop_][Loop][T_MARQUEE];[scrollamount][Scrollamount][T_MARQUEE];[value][Value][T_LI];[start][Start][T_OL];)]#[allow(non_snake_case)]impl T{pub fn g(&mut self ,x:u32) ->String  {
		return self .f(x) .0 .print()  ;}}
#[duplicate(f g T; [width][Width][T_VIDEO];[height][Height][T_VIDEO];[size][Size][T_SELECT];[minlength][Minlength][T_INPUT];[size][Size][T_INPUT];[cols][Cols][T_TEXTAREA];[rows][Rows][T_TEXTAREA];[maxlength][Maxlength][T_TEXTAREA];)]#[allow(non_snake_case)]impl T{pub fn g(&mut self ,x:i32) ->String  {
		return self .f(x) .0 .print()  ;}}
#[duplicate(f g T; [autocomplete][Autocomplete][T_FORM]; [autocomplete][Autocomplete][T_INPUT];)]#[allow(non_snake_case)]impl T{pub fn g(&mut self ,b:bool) ->String  {
		return self .f(b) .0 .print()  ;}}
#[duplicate(f g T; [ping][Ping][T_A];)]#[allow(non_snake_case)]impl T{pub fn g(&mut self ,xs:Vec<&str>) ->String  {
		return self .f(xs) .0 .print()  ;}}
pub fn doctype(val:&str) ->String  {
	return format!("<!doctype html>{}" ,val)  ;}
// end  ;
