by [ontology](https://onto.logy.at/)

A dsl (domain specific language) for writing html. This is NOT an html template (there are lots of those).
This library is not complete and most possibly will never be -html is huge.

## usage
```
use onhtml::*  ;
fn myhomepage1() ->String  {
	let mut x = Title("a page")  ;
	x += &meta() .name("description") .Content("bla bla")  ;
	x += &Style("some inline css")  ;
	x = Head(&x)  ;
	let mut y = a("nst") .href("nst.com") .Download()  ;
	y += &P("nst")  ;
	x += &Body(&y)  ;
	x += &script("") .type_("module") .Src("/res/main.js")  ;
	x = html(&x) .Lang("en")  ;
	doctype(&x)}
fn myhomepage2() ->String  {
	let mut x = Title("a page")  ;
	x += &meta() .name("description") .Content("bla bla")  ;
	x += &link() .rel("stylesheet") .Href("/mycss.css")  ;
	x = Head(&x)  ;
	let mut y = a("nst") .href("nst.com") .data("a","1") .Download()  ;
	y += &P("nst")  ;
	x += &Body(&y)  ;
	x += &script("") .type_("script") .Src("/res/main.js")  ;
	x = html(&x) .Lang("en")  ;
	doctype(&x)}
```

Notice that -and this is against rust conventions- some functions are capitalized. Every function has 2 variants. You can view the capitalized function as the non capitalized function call, followed by a hypothetical .finish() method to close the builder. i.e.
```
let x = a("some link") .href("https://somelink.com") .finish()
```
instead of having the above, we have:
```
let x = a("some link") .Href("https://somelink.com")
```
This was decided for purely ergonomic reasons.

Since everything is a String, if the library misses something, you can always add it manually:
```
let mut x = Div("some content")
x += "<span>some content</span>"
```

**note:** function names that collide with rust's reserved keywords (type, loop etc) are suffixed with an underscore. i.e. type_

