//! # one-time
//! Compute HOTP and TOTP values according to RFCs 4226 and 6238.
//!
//! This implementation is digest-agnostic.
//!
//! ## Features
//! All features are disabled by default.
//! - **`std`**: makes `Error` implement `std::error::Error` and uses `std::time::SystemTime` for `totp_now`
//! - **`libc`**: use libc for getting the time for `totp_now`
//!
//! If `std` and `libc` are both enabled, `libc` will be used for `totp_now`.

#![cfg_attr(not(feature = "std"), no_std)]

pub mod error;
pub mod hotp;
pub mod totp;

pub use self::hotp::hotp;
pub use self::totp::totp;

#[cfg(any(feature = "std", feature = "libc"))]
pub use self::totp::totp_now;

#[cfg(test)]
mod test;
