#[cfg(feature = "std")]
use thiserror::Error;

use hmac::crypto_mac::InvalidKeyLength;

#[cfg_attr(feature = "std", derive(Error))]
#[derive(Debug)]
pub enum Error {
    #[cfg_attr(feature = "std", error("invalid digits size, must be at least 6"))]
    InvalidDigitsSize,
    #[cfg_attr(feature = "std", error(transparent))]
    InvalidKeySize(#[cfg_attr(feature = "std", from)] InvalidKeyLength),
    #[cfg_attr(feature = "std", error("system time was before the epoch"))]
    InvalidSystemTime,
    #[cfg_attr(feature = "std", error("time step cannot be 0"))]
    InvalidStep,
    #[cfg_attr(feature = "std", error("timestamp must be greater than or equal to the epoch"))]
    InvalidTimeOrEpoch,
}
