// SPDX-FileCopyrightText: 2022 Declan Rixon <declan.fraser.rixon@gmail.com>
//
// SPDX-License-Identifier: GPL-3.0-only

// Public Definitions
pub type ID = &'static str;
pub const INDENTATION: &[u8] = b"    ";
pub const DOCTYPE: &[u8] = b"<!DOCTYPE html>";

// Exports
pub use attribute::Attribute;
pub use data::Data;
pub use placeholder::Placeholder;
pub use tag::Tag;
pub use tag_pair::TagPair;
pub use template::{Substitution, Template};

// Submodules
mod attribute;
mod data;
mod placeholder;
mod tag;
mod tag_pair;
mod template;

// Module for integration tests.
#[cfg(test)]
mod tests;
