// SPDX-FileCopyrightText: 2022 Declan Rixon <declan.fraser.rixon@gmail.com>
//
// SPDX-License-Identifier: GPL-3.0-only

use crate::*;
use std::fmt::{self, Display, Formatter};

#[derive(Clone)]
pub enum Data {
    Rendered(Vec<u8>),
    Placeholder { indent: Option<usize>, id: ID },
    LineStart,
}

impl Display for Data {
    fn fmt(&self, f: &mut Formatter<'_>) -> fmt::Result {
        use Data::*;
        match self {
            Rendered(bytes) => f.write_str(&String::from_utf8_lossy(bytes)),
            Placeholder { indent, id } => write!(
                f,
                "{}{{ {} }}",
                String::from_utf8_lossy(&INDENTATION.repeat(indent.unwrap_or(0))),
                id
            ),
            LineStart => f.write_str("\n"),
        }
    }
}

impl<T> From<T> for Data
where
    Vec<u8>: From<T>,
{
    fn from(t: T) -> Data {
        Data::Rendered(t.into())
    }
}
