// SPDX-FileCopyrightText: 2022 Declan Rixon <declan.fraser.rixon@gmail.com>
//
// SPDX-License-Identifier: GPL-3.0-only

use crate::*;

#[derive(Clone)]
pub struct Attribute {
    name: Data,
    value: Option<Data>,
}

impl Attribute {
    pub fn new<T>(name: T) -> Self
    where
        T: Into<Data>,
    {
        Self {
            name: name.into(),
            value: None,
        }
    }

    pub fn value<T>(mut self, value: T) -> Self
    where
        T: Into<Data>,
    {
        self.value = Some(value.into());
        self
    }
}

impl From<Attribute> for Template {
    fn from(attribute: Attribute) -> Template {
        let template = Template::new().add(attribute.name);
        if let Some(value) = attribute.value {
            template.add("=\"").add(value).add("\"")
        } else {
            template
        }
    }
}
