# Changelog for version 0.5.0

* Decryption functions don't panic on malformed UTF-8 coded messages anymore. Output is now lossy, returning `U+FFFD` (�), when an invalid UTF-8 symbol was encountered.
* Fixes memory leak on freeing `OlmOutboundGroupSession`.
* Fixes memory leak when using `OlmAccount::unpickle`.
* Fixes memory leak when `OlmInboundGroupSession::unpickle` and `OlmSession::unpickle` encounter an error.
* `OlmOutboundGroupSession::group_session_ptr` is now private.
* To make the creation of `OlmSession`s easier, the respective functions are now part of `OlmAccount`. As a result the parameters specifying the `OlmAccount` are now omitted.
* Removes `OlmAccount::parsed_identity_keys`, because it relied on unstable characteristics for parsing.
* Adds the `deserialization` which using `serde` parses an account's `IdentityKeys` and `OneTimeKeys`.
* `OlmUtility::ed25519_verify`'s argument `signature` no longer needs to be mutable.
* Messages of an Olm session are now represented by `OlmMessage`, which can either be `Message` or `PreKey`, instead of a simple string. Arguments taken and values returned from functions have been adjusted accordingly.
* `OlmMessageType` now implements the traits `Into<usize>` and `TryFrom<usize>`.
* `OlmAccountError`, `OlmSessionError`, and `OlmGroupSessionError` now all implement the `Error` trait.
* `OlmAccount`, `OlmSession`, `OlmInboundGroupSession`, and `OlmOutboundGroupSession` now all implement the `Send` trait.

### Internal changes

* Removal of a lot of code duplication for handling fatal errors. This should also make the error messages more consistent.
* Removal of a lot of code that unneccessarily boxed buffers.
* In the rare case that getting random data fails, we panic now. This is significantly preferable to creating insecure keys.
* Key, plaintext, and random data buffers used to be cleared by standard deallocation. Now they are zeroed out beforehand, to make sure this critical information is properly destroyed.

### Contributors

A huge thank you to poljar, who has done most of the work on this release!

---

Johannes Hayeß
