# Contributing to olm-rs

### libolm API references
The header `olm.h` from which we generate the bindings used in this library is well documented. If you want to know what a function used from libolm does, it's best to look there.
What parameters need be used for each function from libolm's bindings can be identified by looking at the [autogenerated documentation](https://docs.rs/olm-sys) of `olm-sys`.

To understand how things interoperate you can have a look at the [E2E implementation guide for Matrix](https://matrix.org/docs/guides/e2e_implementation.html).

### Contributing guidelines
Before filing a merge request, make sure of the following things:

* all unit tests pass
* your code is formatted using `rustfmt`, for consistency
* variables that store buffers for libolm to write into end with `_buf`
* variables that store the length of a buffer for libolm end with `_len`
* variables that store raw pointers used as function parameters for libolm end with `_ptr`

If you added functionality that is currently not coverd by unit tests, it would be highly appreciated if you could implemented the according test cases.

Alternatively you can submit patches via email. Send your patches and questions to `jhaye[at]mailbox.org`.
