# olc-pge

An *unofficial* reimplementation of the olcPixelGameEngine in Rust. If there is ever an official version of the olcPixelGameEngine for Rust, I will happily give up the crate. This uses the OLC-3 license, as it is a derivative work. This license is included in `LICENSE.md`.

## Missing Features

* Real documentation
* Anything added in PGE 2.0 or above
* Resource Packs
* Mouse buttons higher than 2
* Fullscreen
* Vsync
* `PixelMode::Custom` just functions as `PixelMode::Normal`
* `set_screen_size()` does nothing
* `set_sub_pixel_offset()` does nothing
* `draw_partial_sprite_scaled()` doesn't support `scale` > 1. I can't be bothered right now. It actually just causes a `panic!()`. Don't try it.

## Added Features

Added support for almost every key a on a US keyboard, including left/right versions of control, shift, alt, and the windows key. I added these because I wanted to take a whack at making a text editor, and I needed more keys.

The `Return` key is the one on most people call enter. The `Enter` key is both the `Return` key and the `NumPadEnter` key. Similar to how `Shift` is both `LeftShift` and `RightShift`.

Currently, for reasons I have yet to explain, alt and F10 can't be captured. This seems to be a limitation of `minifb`. It's probably limited to Windows. I'm still looking in to it.

The Windows key also can't be captured, but whatever, I didn't really expect to be able to, but it's *available* in the enum as `System`, `LeftSystem`, and `RightSystem`. Maybe they work on Linux or Mac? Who knows? Not me.

I also didn't add `F13`-`F24`. I'm sure none of you actually need them, most of you didn't know they even existed, and minifb only supports up to `F15` anyway.

## Platforms

In theory, it supports anything that `image` and `minifb` do, but it's only been tested on Windows. Please let me know if it doesn't work on other platforms. I will at least *attempt* to fix it, but if you provide a fix, that saves me the effort.

## Changes to Accomodate Rust

### Function Overloads / Default Parameters

Rather, lack thereof. Rust doesn't support this. Drawing functions that supported an optional `scale`, `pattern`, or `mask`, and could handle either vectors or individual components, now have multiple functions.
```cpp
void DrawLine(int32_t x1, int32_t y1, int32_t x2, int32_t y2, Pixel p = olc::WHITE, uint32_t pattern = 0xFFFFFFFF);
```
This one line became the the following 4 functions:
```rust
fn draw_line(&mut self, x1: i32, y1: i32, x2: i32, y2: i32, p: Pixel);
fn draw_line_pattern(&mut self, x1: i32, y1: i32, x2: i32, y2: i32, p: Pixel, pattern: u32);

fn draw_line_v(&mut self, pos1: Vi2d, pos2: Vi2d, p: Pixel);
fn draw_line_pattern_v(&mut self, pos1: Vi2d, pos2: Vi2d, p: Pixel, pattern: u32);
```
Isn't it just grand?

### Sprites

The most glaring thing will be the changes to sprites. Every function that originally took a `Sprite *` now takes a `SpriteRef`. This is because raw pointers are unsafe, and really shouldn't be used in rust unless you know damn well what you're going to do with them. I don't know what I'm doing with them, and more importantly, I don't know what *you* are going to do with them. `SpriteRef` is nice and safe. In theory.

To make a `SpriteRef`, call `into_ref()` on a newly created sprite. To pass one in to a function, you're going to have to `clone()` it.

As an example:
```rust
let sprite = olc::Sprite::from_file("path/to/file.png").into_ref();
pge.draw_sprite(0, 0, sprite.clone());
```

A `SpriteRef` is defined as `Rc<RefCell<Sprite>>`. To those unfamiliar, an `Rc<>` gives you a reference counted, *immutable*, reference. Because an `Rc<>` is only ever immutable, and I'm pretty sure some people would like to edit sprites at runtime, we need the `RefCell<>`. These neat little structures provide *interior mutability*. Which is a fancy way of saying you can get a mutable reference to an object inside of an immutable one. A `RefCell<>` has the important feature that it enforces Rust's borrowing rules at runtime. That is to say, you can have 1 mutable reference *OR* many immutable references. Not both.

To do anything through a `SpriteRef`, you'll have to explicitly borrow it first:
```rust
let immutable_ref = sprite.borrow();
// These cannot actually coexist and must be in different scopes
let mutable_ref = sprite.borrow_mut();
```

### Draw Targets

The original C++ API let you just throw any old `Sprite*` in you were off to the races. As discussed above, you can't do that here. It also allowed `null` as target to get back to the default target. I don't really know why, but I tried to keep similar functionality. The argument for `set_draw_target()` is an `Option<SpriteRef>`.
```rust
// to set a custom draw target
pge.set_draw_target(Some(sprite.clone());
// to go back to the default
pge.set_draw_target(None);
```