use crate::repr::{ColorIndexed, ColorRgb8, Image, Palette};
use crate::parser::repr::{Entry, EntryType, Header, WadMagic};

pub fn test_color_indexed_in() -> &'static [u8] {
    &[24u8]
}

pub fn test_color_indexed_out() -> ColorIndexed {
    ColorIndexed(24)
}

pub fn test_color_rgb8_in() -> &'static [u8] {
    &[24u8, 56, 92]
}

pub fn test_color_rgb8_out() -> ColorRgb8 {
    ColorRgb8(24, 56, 92)
}

pub fn test_palette_in() -> &'static [u8] {
    include_bytes!("../test_data/palette/quake.lmp")
}

pub fn test_palette_out() -> Palette {
    Palette([
        ColorRgb8(0, 0, 0),
        ColorRgb8(15, 15, 15),
        ColorRgb8(31, 31, 31),
        ColorRgb8(47, 47, 47),
        ColorRgb8(63, 63, 63),
        ColorRgb8(75, 75, 75),
        ColorRgb8(91, 91, 91),
        ColorRgb8(107, 107, 107),
        ColorRgb8(123, 123, 123),
        ColorRgb8(139, 139, 139),
        ColorRgb8(155, 155, 155),
        ColorRgb8(171, 171, 171),
        ColorRgb8(187, 187, 187),
        ColorRgb8(203, 203, 203),
        ColorRgb8(219, 219, 219),
        ColorRgb8(235, 235, 235),
        ColorRgb8(15, 11, 7),
        ColorRgb8(23, 15, 11),
        ColorRgb8(31, 23, 11),
        ColorRgb8(39, 27, 15),
        ColorRgb8(47, 35, 19),
        ColorRgb8(55, 43, 23),
        ColorRgb8(63, 47, 23),
        ColorRgb8(75, 55, 27),
        ColorRgb8(83, 59, 27),
        ColorRgb8(91, 67, 31),
        ColorRgb8(99, 75, 31),
        ColorRgb8(107, 83, 31),
        ColorRgb8(115, 87, 31),
        ColorRgb8(123, 95, 35),
        ColorRgb8(131, 103, 35),
        ColorRgb8(143, 111, 35),
        ColorRgb8(11, 11, 15),
        ColorRgb8(19, 19, 27),
        ColorRgb8(27, 27, 39),
        ColorRgb8(39, 39, 51),
        ColorRgb8(47, 47, 63),
        ColorRgb8(55, 55, 75),
        ColorRgb8(63, 63, 87),
        ColorRgb8(71, 71, 103),
        ColorRgb8(79, 79, 115),
        ColorRgb8(91, 91, 127),
        ColorRgb8(99, 99, 139),
        ColorRgb8(107, 107, 151),
        ColorRgb8(115, 115, 163),
        ColorRgb8(123, 123, 175),
        ColorRgb8(131, 131, 187),
        ColorRgb8(139, 139, 203),
        ColorRgb8(0, 0, 0),
        ColorRgb8(7, 7, 0),
        ColorRgb8(11, 11, 0),
        ColorRgb8(19, 19, 0),
        ColorRgb8(27, 27, 0),
        ColorRgb8(35, 35, 0),
        ColorRgb8(43, 43, 7),
        ColorRgb8(47, 47, 7),
        ColorRgb8(55, 55, 7),
        ColorRgb8(63, 63, 7),
        ColorRgb8(71, 71, 7),
        ColorRgb8(75, 75, 11),
        ColorRgb8(83, 83, 11),
        ColorRgb8(91, 91, 11),
        ColorRgb8(99, 99, 11),
        ColorRgb8(107, 107, 15),
        ColorRgb8(7, 0, 0),
        ColorRgb8(15, 0, 0),
        ColorRgb8(23, 0, 0),
        ColorRgb8(31, 0, 0),
        ColorRgb8(39, 0, 0),
        ColorRgb8(47, 0, 0),
        ColorRgb8(55, 0, 0),
        ColorRgb8(63, 0, 0),
        ColorRgb8(71, 0, 0),
        ColorRgb8(79, 0, 0),
        ColorRgb8(87, 0, 0),
        ColorRgb8(95, 0, 0),
        ColorRgb8(103, 0, 0),
        ColorRgb8(111, 0, 0),
        ColorRgb8(119, 0, 0),
        ColorRgb8(127, 0, 0),
        ColorRgb8(19, 19, 0),
        ColorRgb8(27, 27, 0),
        ColorRgb8(35, 35, 0),
        ColorRgb8(47, 43, 0),
        ColorRgb8(55, 47, 0),
        ColorRgb8(67, 55, 0),
        ColorRgb8(75, 59, 7),
        ColorRgb8(87, 67, 7),
        ColorRgb8(95, 71, 7),
        ColorRgb8(107, 75, 11),
        ColorRgb8(119, 83, 15),
        ColorRgb8(131, 87, 19),
        ColorRgb8(139, 91, 19),
        ColorRgb8(151, 95, 27),
        ColorRgb8(163, 99, 31),
        ColorRgb8(175, 103, 35),
        ColorRgb8(35, 19, 7),
        ColorRgb8(47, 23, 11),
        ColorRgb8(59, 31, 15),
        ColorRgb8(75, 35, 19),
        ColorRgb8(87, 43, 23),
        ColorRgb8(99, 47, 31),
        ColorRgb8(115, 55, 35),
        ColorRgb8(127, 59, 43),
        ColorRgb8(143, 67, 51),
        ColorRgb8(159, 79, 51),
        ColorRgb8(175, 99, 47),
        ColorRgb8(191, 119, 47),
        ColorRgb8(207, 143, 43),
        ColorRgb8(223, 171, 39),
        ColorRgb8(239, 203, 31),
        ColorRgb8(255, 243, 27),
        ColorRgb8(11, 7, 0),
        ColorRgb8(27, 19, 0),
        ColorRgb8(43, 35, 15),
        ColorRgb8(55, 43, 19),
        ColorRgb8(71, 51, 27),
        ColorRgb8(83, 55, 35),
        ColorRgb8(99, 63, 43),
        ColorRgb8(111, 71, 51),
        ColorRgb8(127, 83, 63),
        ColorRgb8(139, 95, 71),
        ColorRgb8(155, 107, 83),
        ColorRgb8(167, 123, 95),
        ColorRgb8(183, 135, 107),
        ColorRgb8(195, 147, 123),
        ColorRgb8(211, 163, 139),
        ColorRgb8(227, 179, 151),
        ColorRgb8(171, 139, 163),
        ColorRgb8(159, 127, 151),
        ColorRgb8(147, 115, 135),
        ColorRgb8(139, 103, 123),
        ColorRgb8(127, 91, 111),
        ColorRgb8(119, 83, 99),
        ColorRgb8(107, 75, 87),
        ColorRgb8(95, 63, 75),
        ColorRgb8(87, 55, 67),
        ColorRgb8(75, 47, 55),
        ColorRgb8(67, 39, 47),
        ColorRgb8(55, 31, 35),
        ColorRgb8(43, 23, 27),
        ColorRgb8(35, 19, 19),
        ColorRgb8(23, 11, 11),
        ColorRgb8(15, 7, 7),
        ColorRgb8(187, 115, 159),
        ColorRgb8(175, 107, 143),
        ColorRgb8(163, 95, 131),
        ColorRgb8(151, 87, 119),
        ColorRgb8(139, 79, 107),
        ColorRgb8(127, 75, 95),
        ColorRgb8(115, 67, 83),
        ColorRgb8(107, 59, 75),
        ColorRgb8(95, 51, 63),
        ColorRgb8(83, 43, 55),
        ColorRgb8(71, 35, 43),
        ColorRgb8(59, 31, 35),
        ColorRgb8(47, 23, 27),
        ColorRgb8(35, 19, 19),
        ColorRgb8(23, 11, 11),
        ColorRgb8(15, 7, 7),
        ColorRgb8(219, 195, 187),
        ColorRgb8(203, 179, 167),
        ColorRgb8(191, 163, 155),
        ColorRgb8(175, 151, 139),
        ColorRgb8(163, 135, 123),
        ColorRgb8(151, 123, 111),
        ColorRgb8(135, 111, 95),
        ColorRgb8(123, 99, 83),
        ColorRgb8(107, 87, 71),
        ColorRgb8(95, 75, 59),
        ColorRgb8(83, 63, 51),
        ColorRgb8(67, 51, 39),
        ColorRgb8(55, 43, 31),
        ColorRgb8(39, 31, 23),
        ColorRgb8(27, 19, 15),
        ColorRgb8(15, 11, 7),
        ColorRgb8(111, 131, 123),
        ColorRgb8(103, 123, 111),
        ColorRgb8(95, 115, 103),
        ColorRgb8(87, 107, 95),
        ColorRgb8(79, 99, 87),
        ColorRgb8(71, 91, 79),
        ColorRgb8(63, 83, 71),
        ColorRgb8(55, 75, 63),
        ColorRgb8(47, 67, 55),
        ColorRgb8(43, 59, 47),
        ColorRgb8(35, 51, 39),
        ColorRgb8(31, 43, 31),
        ColorRgb8(23, 35, 23),
        ColorRgb8(15, 27, 19),
        ColorRgb8(11, 19, 11),
        ColorRgb8(7, 11, 7),
        ColorRgb8(255, 243, 27),
        ColorRgb8(239, 223, 23),
        ColorRgb8(219, 203, 19),
        ColorRgb8(203, 183, 15),
        ColorRgb8(187, 167, 15),
        ColorRgb8(171, 151, 11),
        ColorRgb8(155, 131, 7),
        ColorRgb8(139, 115, 7),
        ColorRgb8(123, 99, 7),
        ColorRgb8(107, 83, 0),
        ColorRgb8(91, 71, 0),
        ColorRgb8(75, 55, 0),
        ColorRgb8(59, 43, 0),
        ColorRgb8(43, 31, 0),
        ColorRgb8(27, 15, 0),
        ColorRgb8(11, 7, 0),
        ColorRgb8(0, 0, 255),
        ColorRgb8(11, 11, 239),
        ColorRgb8(19, 19, 223),
        ColorRgb8(27, 27, 207),
        ColorRgb8(35, 35, 191),
        ColorRgb8(43, 43, 175),
        ColorRgb8(47, 47, 159),
        ColorRgb8(47, 47, 143),
        ColorRgb8(47, 47, 127),
        ColorRgb8(47, 47, 111),
        ColorRgb8(47, 47, 95),
        ColorRgb8(43, 43, 79),
        ColorRgb8(35, 35, 63),
        ColorRgb8(27, 27, 47),
        ColorRgb8(19, 19, 31),
        ColorRgb8(11, 11, 15),
        ColorRgb8(43, 0, 0),
        ColorRgb8(59, 0, 0),
        ColorRgb8(75, 7, 0),
        ColorRgb8(95, 7, 0),
        ColorRgb8(111, 15, 0),
        ColorRgb8(127, 23, 7),
        ColorRgb8(147, 31, 7),
        ColorRgb8(163, 39, 11),
        ColorRgb8(183, 51, 15),
        ColorRgb8(195, 75, 27),
        ColorRgb8(207, 99, 43),
        ColorRgb8(219, 127, 59),
        ColorRgb8(227, 151, 79),
        ColorRgb8(231, 171, 95),
        ColorRgb8(239, 191, 119),
        ColorRgb8(247, 211, 139),
        ColorRgb8(167, 123, 59),
        ColorRgb8(183, 155, 55),
        ColorRgb8(199, 195, 55),
        ColorRgb8(231, 227, 87),
        ColorRgb8(127, 191, 255),
        ColorRgb8(171, 231, 255),
        ColorRgb8(215, 255, 255),
        ColorRgb8(103, 0, 0),
        ColorRgb8(139, 0, 0),
        ColorRgb8(179, 0, 0),
        ColorRgb8(215, 0, 0),
        ColorRgb8(255, 0, 0),
        ColorRgb8(255, 243, 147),
        ColorRgb8(255, 247, 199),
        ColorRgb8(255, 255, 255),
        ColorRgb8(159, 91, 83),
    ])
}

pub fn test_header_in() -> Vec<u8> {
    [*b"WAD2", 10u32.to_le_bytes(), 24u32.to_le_bytes()].concat()
}

pub fn test_header_out() -> Header {
    Header {
        magic: WadMagic::Wad2,
        num_entries: 10,
        dir_offset: 24,
    }
}

pub fn test_entry_in() -> Vec<u8> {
    [
        [
            200u32.to_le_bytes(),
            16u32.to_le_bytes(),
            32u32.to_le_bytes(),
        ]
        .concat(),
        vec![b'@', 0u8],
        0u16.to_le_bytes().to_vec(),
        b"texture\0\0\0\0\0\0\0\0\0".to_vec(),
    ]
    .concat()
}

pub fn test_entry_out() -> Entry<'static> {
    Entry {
        offset: 200,
        size_directory: 16,
        size_memory: 32,
        entry_type: EntryType::Unknown,
        compression: 0,
        name: "texture",
    }
}

pub fn test_image_in() -> &'static [u8] {
    &[0, 2, 4, 6, 8, 10, 12, 16, 18, 20, 22, 24, 26, 28, 30, 32]
}

pub fn test_image_out() -> Image {
    Image(
        vec![0, 2, 4, 6, 8, 10, 12, 16, 18, 20, 22, 24, 26, 28, 30, 32]
            .into_iter()
            .map(ColorIndexed)
            .collect::<Vec<_>>(),
    )
}
