use crate::{types, Party, Result, Store};
use async_trait::async_trait;

#[async_trait]
pub trait PartyStore
where
    Self: Store + Send + 'static,
{
    type PartyModel: Party;
    type TemporaryModel;

    async fn delete_party(&self, party_id: <Self::PartyModel as Party>::Id) -> Result<()>;

    async fn save_new_party(
        &self,
        temporary_model: Self::TemporaryModel,
        credentials: types::Credential,
        details: types::VersionDetails,
    ) -> Result<Self::PartyModel>;

    async fn update_party(
        &self,
        model: Self::PartyModel,
        credentials: types::Credential,
        details: types::VersionDetails,
    ) -> Result<Self::PartyModel>;

    async fn get_our_roles(&self) -> Result<Vec<types::CredentialsRole>>;
}
