use {
    super::{InterfaceRole, ModuleId},
    url::Url,
};

#[derive(Clone, Debug, PartialEq, Eq, serde::Serialize, serde::Deserialize)]
pub struct Endpoint {
    pub identifier: ModuleId,
    pub role: InterfaceRole,
    pub url: Url,
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn deserialize_example() {
        let example = r#"
[
{
"identifier": "credentials",
"role": "SENDER",
"url": "https://example.com/ocpi/2.2/credentials/"
},
{
"identifier": "locations",
"role": "SENDER",
"url": "https://example.com/ocpi/cpo/2.2/locations/"
}
]
"#;

        let des = serde_json::from_str::<Vec<Endpoint>>(example).expect("Deserializing");

        assert_eq!(des[0].identifier, ModuleId::Credentials);
        assert_eq!(des[0].role, InterfaceRole::Sender);
        assert_eq!(
            des[0].url.to_string(),
            "https://example.com/ocpi/2.2/credentials/"
        );

        assert_eq!(des[1].identifier, ModuleId::Locations);
        assert_eq!(des[1].role, InterfaceRole::Sender);
        assert_eq!(
            des[1].url.to_string(),
            "https://example.com/ocpi/cpo/2.2/locations/"
        );
    }
}
