//! credentials/types/mod.rs
//!
//! This module contains the types used by the OCPI Credentials module.
//!

mod business_details;
mod credential;
mod credentials_role;
mod date_time;
mod endpoint;
mod image;
mod image_category;
mod interface_role;
mod module_id;
mod role;
mod strings;
mod version;
mod version_details;
mod version_number;

pub use {
    business_details::*,
    credential::*,
    credentials_role::*,
    date_time::*,
    endpoint::*,
    image::*,
    image_category::*,
    interface_role::*,
    module_id::*,
    role::*,
    strings::{CiString, CsString, StringError},
    version::*,
    version_details::*,
    version_number::*,
};

pub use chrono::Duration;
pub use url::Url;

pub type CredentialsToken = CsString<64>;
