use crate::types;

/// Represents a Party in the Ocpi Protocol.
pub trait Party {
    type Id: Send + 'static;

    fn id(&self) -> Self::Id;

    fn token_we_use(&self) -> types::CredentialsToken;

    fn token_they_use(&self) -> types::CredentialsToken;
}
