use super::CiString;
use url::Url;

/// # 8.4.15. Image class
/// This class references an image related to an EVSE in terms of a file name or url.
/// According to the roaming connection between one EVSE Operator and one or more
/// Navigation Service Providers,
/// the hosting or file exchange of image payload data has to be defined.
/// The exchange of this content data is out of scope of OCPI.
/// However, the recommended setup is a public available web server hosted and updated
/// by the EVSE Operator.
/// Per charge point an unlimited number of images of each type is allowed.
/// Recommended are at least two images where one is a network or provider logo and the
/// second is a station photo.
/// If two images of the same type are defined, not only one should be selected but both
/// should be displayed together.
///
/// ### Photo Dimensions:
/// The recommended dimensions for all photos is a
/// minimum width of 800 pixels
/// and a minimum height of 600 pixels.
/// Thumbnail should always have the same orientation as the original photo
/// with a size of 200 by 200 pixels.
///
/// ### Logo Dimensions:
/// The recommended dimensions for logos are exactly 512 pixels in width height.
/// Thumbnail representations of logos should be exactly 128 pixels in width and height.
/// If not squared, thumbnails should have the same orientation as the original.
///

#[derive(Clone, Debug, PartialEq, Eq, serde::Serialize, serde::Deserialize)]
pub struct Image {
    /// URL from where the image data can be fetched through a web browser.
    pub url: Url,

    /// URL from where a thumbnail of the image can be fetched through a
    /// webbrowser.
    pub thumbnail: Option<Url>,

    /// Describes what the image is used for.
    pub category: super::ImageCategory,

    /// Image type like: gif, jpeg, png, svg.
    pub r#type: CiString<4>,

    /// Width of the full scale image.
    pub width: Option<i32>,

    /// Height of the full scale image.
    pub height: Option<i32>,
}
