/// The context of an OCPI call.
#[derive(Clone, Debug, PartialEq, Eq)]
pub struct Context<T>(T);

impl<T> Context<T> {
    pub fn new(t: T) -> Self {
        Self(t)
    }
}

impl<T> Context<T> {
    pub fn into_inner(self) -> T {
        self.0
    }
}

impl<T> AsRef<T> for Context<T> {
    fn as_ref(&self) -> &T {
        &self.0
    }
}
