use std::fmt::{self, Display};
use syn::{Ident, Path};

/// A type to represent the name of a macro attribute.
#[derive(Copy, Clone)]
pub struct Symbol(&'static str);

pub const NO_MAIN: Symbol = Symbol("no_main");
pub const OCKAM_CRATE: Symbol = Symbol("crate");
pub const TIMEOUT_MS: Symbol = Symbol("timeout");

impl PartialEq<Symbol> for Ident {
    fn eq(&self, word: &Symbol) -> bool {
        self == word.0
    }
}

impl<'a> PartialEq<Symbol> for &'a Ident {
    fn eq(&self, word: &Symbol) -> bool {
        *self == word.0
    }
}

impl PartialEq<Symbol> for Path {
    fn eq(&self, word: &Symbol) -> bool {
        self.is_ident(word.0)
    }
}

impl<'a> PartialEq<Symbol> for &'a Path {
    fn eq(&self, word: &Symbol) -> bool {
        self.is_ident(word.0)
    }
}

impl Display for Symbol {
    fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
        formatter.write_str(self.0)
    }
}
