use std::env;
use std::fs::File;
use std::io::Write;
use std::process::Command;
use std::str::from_utf8;

pub fn oce() {
    let filename = "result";
    let all = env::args().collect::<Vec<String>>();

    if all.len() == 1 {
        println!("Need a command");
        return;
    }

    let input = &all[1..];
    let mut output_file = File::create(filename).expect("Failed to create a file.");

    let command = &input[0];
    let args = &input[1..];

    let output = Command::new(command)
        .args(args)
        .output()
        .expect("Couldn't execute the command.");
    let result =
        from_utf8(&output.stdout).expect("Couldn't make a string from the command's result.");
    write!(output_file, "$ {}\n{}", input.join(" "), result.trim())
        .expect("Couldn't output anything.");
}

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        assert_eq!(2 + 2, 4);
    }
}
