

use std::env;
use std::path::PathBuf;

fn main() {
    let occlum_include_dir = "/opt/occlum/include";
    let occlum_lib_dir = "/opt/occlum/build/lib";
    let occlum_lib = "occlum-pal";

    println!("cargo:include={}", occlum_include_dir);
    println!("cargo:rustc-link-search={}", occlum_lib_dir);
    println!("cargo:rustc-link-lib={}", occlum_lib);

    let bindings = bindgen::Builder::default()
        .header("c_api/occlum_pal_api.h")
        .allowlist_function("occlum_.*")
        .allowlist_type("occlum_.*")
        .size_t_is_usize(true)
        .derive_copy(true)
        .derive_debug(true)
        .derive_default(true)
        .derive_eq(true)
        .layout_tests(true)
        .prepend_enum_name(true)
        .rustfmt_bindings(true)
        .generate()
        .expect("Unable to generate bindings");

    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("Couldn't write bindings!");
}
