# Contributing to Oberon

Oberson is Apache 2.0 licensed and accepts contributions via
[GitHub](https://github.com/mikelodder7/oberon) pull requests.

# Ways to contribute to Oberon

- Bugs or issues: Report problems or defects as github issues
- Features and enhancements: Provide expanded capabilities or optimizations
- Documentation: Improve existing documentation or create new information
- Tests for events and results:
    - Functional
    - Performance
    - Usability
    - Security
    - Localization
    - Deployability

# The Commit Process

When contributing code, please follow these guidelines:

- Fork the repository and make your changes in a feature branch
- Include unit and integration tests for any new features and updates to existing tests
- Ensure that the unit and integration tests run successfully.
- Check that the lint tests pass

## Important
Use `git rebase origin/master` to limit creating merge commits

## Commit Email Address
Your commit email address must match your GitHub or GitLab email address. For more information, see https://help.github.com/articles/setting-your-commit-email-address-in-git/.
