pub enum ErrorCode {
    InvalidRequest,
    UnauthorizedClient,
    AccessDenied,
    UnsupportedResponseType,
    InvalidScope,
    ServerError,
    TemporarilyUnavailable,
}

pub struct OAuthError {
    pub error: ErrorCode,
    pub error_description: String,
    pub state: Option<String>,
}

impl OAuthError {
    pub fn new(error: ErrorCode, state: Option<String>) -> OAuthError {
        OAuthError {
            error: error,
            error_description: "".to_string(),
            state: state,
        }
    }
}

unsafe impl Send for OAuthError {}
unsafe impl Sync for OAuthError {}