use base64::{decode, DecodeError};
use rand::{distributions::Alphanumeric, Rng};
use sha2::{Digest, Sha256};

pub fn random_secure_string(length: usize) -> String {
    rand::thread_rng()
        .sample_iter(&Alphanumeric)
        .take(length)
        .map(char::from)
        .collect()
}

pub fn sha256(input: &str) -> Vec<u8> {
    let mut hasher = Sha256::new();
    hasher.update(input.as_bytes());
    hasher.finalize().to_vec()
}

pub fn decode_base64(input: &str) -> Result<String, DecodeError> {
    decode(input).map(|bytes| String::from_utf8(bytes).unwrap())
}
