#[derive(Debug, PartialEq, Eq, Clone, Copy)]
pub enum TokenEndpointAuthMethod {
    None,
    ClientSecretPost,
    ClientSecretBasic,
}

#[derive(Debug, PartialEq, Eq, Clone, Copy)]
pub enum GrantType {
    AuthorizationCode,
    ClientCredentials,
}

#[derive(Debug, PartialEq, Eq, Clone, Copy)]
pub enum ResponseType {
    Code,
}

#[derive(Debug, Clone)]
pub struct Client {
    pub(crate) id: String,
    pub(crate) secret: Option<String>,
    pub(crate) redirect_uris: Vec<String>,
    pub(crate) token_endpoint_auth_method: TokenEndpointAuthMethod,
    pub(crate) grant_types: Vec<GrantType>,
    pub(crate) response_types: Vec<ResponseType>,
    pub(crate) name: String,
    pub(crate) uri: String,
    pub(crate) logo_uri: String,
    pub(crate) scopes: Vec<String>,
    pub(crate) contacts: Vec<String>,
    pub(crate) tos_uri: String,
    pub(crate) policy_uri: String,
}