# oauth21-server

A library to easily create an OAuth 2.1 compliant authorization server. The motivation to develop this library comes from the fact that although many libraries to create OAuth clients exist, there are almost no libraries that create OAuth servers.

There is one problem with this library: this library does not implement any of the REST handlers as described by OAuth 2.1. Instead, this is left as an implementation detail of the consumer of the library. This means that one would still need to read through the IETF draft to identify the correct way to implement the handlers. However, the functions would have to convert the inputs from the request to the proper request structure and pass that on.

The basis of the library revolves around the `Provider` trait. This trait defines several functions, most of which deal with interactions with the client. The only required functions deal with database, providing a layer of abstraction over the choice of data storage. Similary, the `Provider` trait relies on a custom set of requests and responses, which are in turn dependent on the flow used.

Essentially, there are a few components that the user of this library needs to implement:

1. Implement the four database-related functions: `store_client`, `get_client`, `save_authorization_information`, `get_authorization_information`, and `remove_authorization_information`.
2. Implement the REST handlers as described by [OAuth 2.1](https://datatracker.ietf.org/doc/html/draft-ietf-oauth-v2-1-01)
3. Add the the signin flow during the authorization request, if the intended flow requires such interaction (e.g. Authorization Code Flow).
