![test workflow](https://github.com/tos-kamiya/o-o/workflows/Tests/badge.svg)

o-o
===

標準入出力を想定しているコマンドをコマンドラインに指定されたファイルへと読み書きできるようにする。

## 何でこんなものを？

コマンドを起動するコマンドとリダイレクトが微妙に干渉してこまったことはありませんか？

例えば、次のコマンドラインは、

```sh
ls *.txt | xargs -I {} head -n 3 {} > {}-head.out
```

実行すると、`*.txt`ファイルのそれぞれに`*-head.out`ファイルを生成しません。
すべての`head`コマンドの実行の結果を含む一つの`{}-head.out`を生成します。

このような場合に`o-o`を使ってください。

次のように実行できます。

```sh
ls *.txt | xargs -I {} o-o - {}-head.out - head -3 {}
```

## 使い方

`o-o`の引数は、子プロセスの標準入力、標準出力、標準エラー出力で、それ以降の引数は子プロセスを起動するためのコマンドラインです。

標準入力等のファイル名として`-`を指定したものはリダイレクトしません。ファイル名の前に`+`を付けると追加モードでファイルを開きます。

```
サブプロセスの標準的I/Oをリダイレクトします。

利用法:
  o-o [options] <stdin> <stdout> <stderr> [--] <commandline>...
  o-o --help
  o-o --version

オプション:
  <stdin>       標準入力として扱われるファイルです。 `-` でリダイレクトしません。
  <stdout>      標準出力として使われるファイルです。 `-` でリダイレクトしません。標準入力と同じファイルにする場合は `=` とします。
  <stderr>      標準エラー出力として扱われるファイルです。 `-` でリダイレクトしません。標準出力と同じファイルにする場合は `=` とします。
                ファイル名の前に `+` を付けると追加モードになります（リダイレクトの `>>` と同じです）。
  -e VAR=VALUE                      環境変数。
  --pipe=STR, -p STR                文字列をサブプロセスをつなげるパイプ（つまり`|`）の代わりに利用します。
  --force-overwrite, -F             終了ステータスが != 0 のときでもファイルを上書きします。<stdout> が `=` のときのみ有効です。
  --working-directory=DIR, -d DIR   作業するディレクトリ。
```

## インストール

Cargoコマンドによりインストールしてください。

```sh
cargo install o-o
```

## ライセンス

MIT/Apache-2.0

## Todos

- [x] Rustで再実装
- [ ] `--force-overwrite`のテスト
