//! Constants for communicating with the OS about dialog styles, etc.
//! What starts with DIALOGSTYLE is Constants that set the dialog icon information.
//! What starts with BUTTONSTYLE is a constant for changing the buttons in the dialog.

// Dialog Styles

#[cfg(windows)]
/// Don't show any icons
pub const DIALOGSTYLE_NONE: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONMASK;
#[cfg(windows)]
/// Information dialog
pub const DIALOGSTYLE_INFORMATION: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONINFORMATION;
#[cfg(windows)]
/// Question dialog
pub const DIALOGSTYLE_QUESTION: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONQUESTION;
#[cfg(windows)]
/// Warning dialog
pub const DIALOGSTYLE_WARNING: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONWARNING;
#[cfg(windows)]
/// Error Dialog
pub const DIALOGSTYLE_ERROR: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONERROR;

#[cfg(unix)]
/// Don't show any icons
pub const DIALOGSTYLE_NONE: gtk::MessageType = gtk::MessageType::Other;
#[cfg(unix)]
/// Information dialog
pub const DIALOGSTYLE_INFORMATION: gtk::MessageType = gtk::MessageType::Info;
#[cfg(unix)]
/// Question dialog
pub const DIALOGSTYLE_QUESTION: gtk::MessageType = gtk::MessageType::Question;
#[cfg(unix)]
/// Warning dialog
pub const DIALOGSTYLE_WARNING: gtk::MessageType = gtk::MessageType::Warning;
#[cfg(unix)]
/// Error Dialog
pub const DIALOGSTYLE_ERROR: gtk::MessageType = gtk::MessageType::Error;

// Button Styles

#[cfg(windows)]
/// OK Button
pub const BUTTONSTYLE_OK: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OK;
#[cfg(windows)]
/// OKCancel Buttons
pub const BUTTONSTYLE_OKCANCEL: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OKCANCEL;
#[cfg(windows)]
/// YESNo Buttons
pub const BUTTONSTYLE_YESNO: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_YESNO;

#[cfg(unix)]
/// OK Button
pub const BUTTONSTYLE_OK: gtk::ButtonsType = gtk::ButtonsType::Ok;
#[cfg(unix)]
/// OKCancel Buttons
pub const BUTTONSTYLE_OKCANCEL: gtk::ButtonsType = gtk::ButtonsType::OkCancel;
#[cfg(unix)]
/// YESNo Buttons
pub const BUTTONSTYLE_YESNO: gtk::ButtonsType = gtk::ButtonsType::YesNo;

// Dialog Results

#[cfg(windows)]
/// If the YES button in the dialog is pressed
pub const RESULTS_YES: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDYES;
#[cfg(windows)]
/// If the NO button in the dialog is pressed
pub const RESULTS_NO: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDNO;
#[cfg(windows)]
/// If the OK button in the dialog is pressed
pub const RESULTS_OK: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDOK;
#[cfg(windows)]
/// If the Cancel button in the dialog is pressed
pub const RESULTS_CANCEL: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDCANCEL;

#[cfg(unix)]
/// If the YES button in the dialog is pressed
pub const RESULTS_YES: gtk::ResponseType = gtk::ResponseType::Yes;
#[cfg(unix)]
/// If the NO button in the dialog is pressed
pub const RESULTS_NO: gtk::ResponseType = gtk::ResponseType::No;
#[cfg(unix)]
/// If the OK button in the dialog is pressed
pub const RESULTS_OK: gtk::ResponseType = gtk::ResponseType::Ok;
#[cfg(unix)]
/// If the Cancel button in the dialog is pressed
pub const RESULTS_CANCEL: gtk::ResponseType = gtk::ResponseType::Cancel;

// Window Styles
#[cfg(windows)]
/// Standard window
pub const WINDOWSTYLE_NORMAL: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows_sys::Win32::UI::WindowsAndMessaging::WS_OVERLAPPEDWINDOW;
#[cfg(windows)]
/// A window with only a close button
pub const WINDOWSTYLE_ONLYEXIT: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows_sys::Win32::UI::WindowsAndMessaging::WS_SYSMENU;
#[cfg(windows)]
/// Window with no caption
pub const WINDOWSTYLE_NOCAPTION: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows_sys::Win32::UI::WindowsAndMessaging::WS_CAPTION;


#[cfg(unix)]
/// Standard window
pub const WINDOWSTYLE_NORMAL: gtk::WindowType = gtk::WindowType::Toplevel;
