use crate::messagebox::MessageBox;
use crate::natives_and_messaging::*;
use crate::window::{Application, Frame, WindowAttributes};

pub struct DemoWindow {

}

impl DemoWindow {
    pub fn new() -> Self {
        Self {

        }
    }
}

impl Application for DemoWindow {
    fn title(&self) -> String {
        "Demo Application".to_string()
    }

    fn attributes(&self) -> WindowAttributes {
        WindowAttributes::new(WINDOWSTYLE_NORMAL, 1280, 750, 500, 500)
    }

    fn startup(&self) {
        println!("Startup!");
    }

    fn ui(&self,frame: Frame) {
        frame.show();
        match MessageBox::new("Do you want to maximize the window?".to_string(), "Do you want to maximize the window?".to_string(), DIALOGSTYLE_QUESTION, BUTTONSTYLE_YESNO).show() {
            RESULTS_YES => {
                frame.show_maximized();
                frame.set_title("The window has been maximized.".to_string());
            }

            RESULTS_NO => {
                frame.show_minimized();
                frame.set_title("The window has been minimized.".to_string());
            }

            _ => {}
        }
    }

    fn exit(&self) {
        println!("Exit Application");
    }
}