use std::borrow::BorrowMut;
use windows::{core::*, Win32::Foundation::*, Win32::Graphics::Gdi::ValidateRect, Win32::System::LibraryLoader::GetModuleHandleA, Win32::UI::WindowsAndMessaging::*};
use windows::Win32::Graphics::Dwm::{DWM_BB_ENABLE, DWM_BLURBEHIND, DwmEnableBlurBehindWindow, DwmSetIconicThumbnail, DWMTWR_WINDOW_MARGINS};
use windows::Win32::Graphics::Gdi::{DC_GRADIENT, DC_INBUTTON, DC_SMALLCAP, DrawCaption, GetDC, HRGN};
use windows::Win32::UI::WindowsAndMessaging::{BS_PUSHBUTTON, CreateWindowExA, CW_USEDEFAULT, MB_ICONHAND, MB_ICONMASK, WS_OVERLAPPEDWINDOW, WS_VISIBLE};

#[cfg(windows)]
pub struct WindowManifest {
    pub classname: String,
    pub application_id: String
}

#[cfg(unix)]
pub struct WindowManifest {
    pub classname: String,
    pub application_id: String
}

#[cfg(windows)]
impl WindowManifest {
    pub fn new(classname: String,application_id: String) -> Self {
        Self {
            classname,
            application_id
        }
    }
}

#[cfg(unix)]
impl WindowManifest {
    pub fn new(classname: String,application_id: String) -> Self {
        Self {
            classname,
            application_id
        }
    }
}

#[cfg(windows)]
pub struct WindowAttributes {
    pub width: i32,
    pub height: i32,
    pub x: i32,
    pub y: i32,
    pub title: String,
    pub style: WINDOW_STYLE
}

#[cfg(unix)]
pub struct WindowAttributes {
    pub width: i32,
    pub height: i32,
    pub x: i32,
    pub y: i32,
    pub title: String,
    pub style: WINDOW_STYLE
}

#[cfg(windows)]
impl WindowAttributes {
    pub fn new(width: i32,height: i32,x: i32,y: i32,title: String,style: WINDOW_STYLE) -> Self {
        Self {
            width,
            height,
            x,
            y,
            title,
            style
        }
    }
}

#[cfg(unix)]
impl WindowAttributes {
    pub fn new(width: i32,height: i32,x: i32,y: i32,title: String,style: WINDOW_STYLE) -> Self {
        Self {
            width,
            height,
            x,
            y,
            title,
            style
        }
    }
}

#[cfg(windows)]
pub trait Window {
    fn start(&self) {
        println!("Start");
    }
    fn attributes(&self) -> WindowAttributes;
    fn manifest(&self) -> WindowManifest;
    fn show(&self,attributes: WindowAttributes,manifest: WindowManifest) {
        extern "system" fn wndproc(window: HWND, message: u32, wparam: WPARAM, lparam: LPARAM) -> LRESULT {
            unsafe {
                match message as u32 {
                    WM_PAINT => {
                        println!("WM_PAINT");
                        ValidateRect(window, std::ptr::null());
                        LRESULT(0)
                    }
                    WM_DESTROY => {
                        println!("WM_DESTROY");
                        PostQuitMessage(0);
                        LRESULT(0)
                    }
                    _ => DefWindowProcA(window, message, wparam, lparam),
                }
            }
        }

        unsafe {
            let instance = GetModuleHandleA(None);
            debug_assert!(instance.0 != 0);

            let window_class = "window";

            let mut wc = WNDCLASSA {
                hCursor: LoadCursorW(None, IDC_ARROW),
                hInstance: instance,
                lpszClassName: PSTR(manifest.classname.as_ptr()),

                style: CS_HREDRAW | CS_VREDRAW,
                lpfnWndProc: Some(wndproc),
                ..Default::default()
            };

            let atom = RegisterClassA(&wc);
            debug_assert!(atom != 0);

            let win = CreateWindowExA(Default::default(), window_class, attributes.title, attributes.style
                | WS_VISIBLE,attributes.x,attributes.y,attributes.width,attributes.height,None,None, instance, std::ptr::null_mut());

            let mut message = MSG::default();

            while GetMessageA(&mut message, HWND(0), 0, 0).into() {
                DispatchMessageA(&message);
            }
        }
    }
}

#[cfg(unix)]
pub trait Window {
    fn start(&self) {
        println!("Start");
    }
    fn attributes(&self) -> WindowAttributes;
    fn manifest(&self) -> WindowManifest;
    fn show(&self,attributes: WindowAttributes,manifest: WindowManifest) {
        use gtk::prelude::*;
        let window = gtk::Window::new(gtk::WindowType::Toplevel);

        window.set_title(&*attributes.title);
        window.set_border_width(10);
        window.set_position(gtk::WindowPosition::Center);
        window.set_default_size(attributes.width,attributes.height);

        window.connect_delete_event(|_, _| {
            gtk::main_quit();
            Inhibit(false)
        });

        window.show_all();
        gtk::main();
    }
}